/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(@Nullable UastNode node1, @Nullable UastNode node2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.token == null && node2.token != null) {
            return false;
        }
        if (node2.token != null && !node1.token.value.equals(node2.token.value)) {
            return false;
        }
        if (node1.is(UastNode.Kind.UNSUPPORTED) || node2.is(UastNode.Kind.UNSUPPORTED)) {
            return false;
        }
        CommentFilteredList list1 = new CommentFilteredList(node1.children);
        CommentFilteredList list2 = new CommentFilteredList(node2.children);
        if (list1.computeSize() != list2.computeSize()) {
            return false;
        }
        Iterator child1 = list1.iterator();
        Iterator child2 = list2.iterator();
        while (child1.hasNext()) {
            if (SyntacticEquivalence.areEquivalent((UastNode)child1.next(), (UastNode)child2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(List<UastNode> node1, List<UastNode> node2) {
        if (node1.size() != node2.size()) {
            return false;
        }
        Iterator<UastNode> it1 = node1.iterator();
        Iterator<UastNode> it2 = node2.iterator();
        while (it1.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    private static class CommentFilteredList {
        private final List<UastNode> children;

        private CommentFilteredList(List<UastNode> children) {
            this.children = children;
        }

        private int computeSize() {
            int size = 0;
            Iterator<UastNode> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            return size;
        }

        private Iterator<UastNode> iterator() {
            return new FilterIterator(this.children.iterator());
        }

        private static class FilterIterator
        implements Iterator<UastNode> {
            private final Iterator<UastNode> iterator;
            private UastNode nextNode;

            private FilterIterator(Iterator<UastNode> iterator) {
                this.iterator = iterator;
                this.nextNode = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public UastNode next() {
                if (this.nextNode == null) {
                    throw new NoSuchElementException();
                }
                UastNode node = this.nextNode;
                this.nextNode = this.findNext();
                return node;
            }

            private UastNode findNext() {
                while (this.iterator.hasNext()) {
                    UastNode node = this.iterator.next();
                    if (node.is(UastNode.Kind.COMMENT)) continue;
                    return node;
                }
                return null;
            }
        }
    }
}

