/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.uast.Unmarshaller;

public final class UastNode {
    public final Set<Kind> kinds;
    public final String nativeNode;
    @Nullable
    public final Token token;
    public final List<UastNode> children;
    @Nullable
    private UastNode parent = null;

    public UastNode(Set<Kind> kinds, String nativeNode, @Nullable Token token, List<UastNode> children) {
        this.kinds = kinds.stream().flatMap(Kind::kindAndExtendedKindStream).collect(Collectors.toSet());
        this.nativeNode = nativeNode;
        this.token = token;
        this.children = children;
        for (UastNode child : children) {
            child.parent = this;
        }
    }

    public static UastNode from(Reader reader) throws IOException {
        return Unmarshaller.unmarshal(reader);
    }

    public Optional<UastNode> getChild(Kind kind) {
        return this.children.stream().filter(kind).findAny();
    }

    public Optional<UastNode> getAncestor(Kind ancestorKind) {
        if (this.parent == null) {
            return Optional.empty();
        }
        if (this.parent.is(ancestorKind)) {
            return Optional.of(this.parent);
        }
        return this.parent.getAncestor(ancestorKind);
    }

    public List<UastNode> getChildren(Kind ... kinds) {
        List selectedChildren = this.children.stream().filter(child -> Arrays.stream(kinds).anyMatch(child.kinds::contains)).collect(Collectors.toList());
        return Collections.unmodifiableList(selectedChildren);
    }

    public void getDescendants(Kind kind, Consumer<UastNode> consumer, Kind ... stopKinds) {
        if (Arrays.stream(stopKinds).noneMatch(this.kinds::contains)) {
            if (this.kinds.contains(kind)) {
                consumer.accept(this);
            }
            this.children.forEach(child -> child.getDescendants(kind, consumer, stopKinds));
        }
    }

    public void getDescendants(Kind kind, Consumer<UastNode> consumer) {
        if (this.kinds.contains(kind)) {
            consumer.accept(this);
        }
        this.children.forEach(child -> child.getDescendants(kind, consumer));
    }

    public boolean hasDescendant(Kind ... kinds) {
        return this.is(kinds) || this.children.stream().anyMatch(child -> child.hasDescendant(kinds));
    }

    public Token firstToken() {
        if (this.token != null && !this.kinds.contains(Kind.COMMENT)) {
            return this.token;
        }
        for (UastNode child : this.children) {
            Token firstToken = child.firstToken();
            if (firstToken == null) continue;
            return firstToken;
        }
        return null;
    }

    public Token lastToken() {
        if (this.token != null && !this.kinds.contains(Kind.COMMENT)) {
            return this.token;
        }
        ListIterator<UastNode> it = this.children.listIterator(this.children.size());
        while (it.hasPrevious()) {
            UastNode child = it.previous();
            Token lastToken = child.lastToken();
            if (lastToken == null) continue;
            return lastToken;
        }
        return null;
    }

    public String joinTokens() {
        StringBuilder sb = new StringBuilder();
        SourcePos pos = this.kinds.contains(Kind.COMPILATION_UNIT) ? new SourcePos(1, 1) : new SourcePos(0, 0);
        this.joinTokens(sb, pos);
        return sb.toString();
    }

    private void joinTokens(StringBuilder sb, SourcePos pos) {
        if (this.token != null) {
            if (pos.line != 0) {
                while (pos.line < this.token.line) {
                    sb.append('\n');
                    ++pos.line;
                    pos.column = 1;
                }
                while (pos.column < this.token.column) {
                    sb.append(' ');
                    ++pos.column;
                }
            }
            sb.append(this.token.value);
            pos.line = this.token.endLine;
            pos.column = this.token.endColumn + 1;
        }
        for (UastNode child : this.children) {
            child.joinTokens(sb, pos);
        }
    }

    public boolean is(Kind ... kinds) {
        for (Kind kind : kinds) {
            if (!this.kinds.contains(kind)) continue;
            return true;
        }
        return false;
    }

    public boolean isNot(Kind ... kinds) {
        return !this.is(kinds);
    }

    public String toString() {
        if (this.token != null) {
            return this.token.toString();
        }
        Token firstToken = this.firstToken();
        return this.kinds.toString() + (firstToken != null ? firstToken.value : "");
    }

    private static class SourcePos {
        int line;
        int column;

        public SourcePos(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }

    public static enum Kind implements Predicate<UastNode>
    {
        CONDITIONAL_JUMP,
        UNCONDITIONAL_JUMP,
        EXPRESSION,
        LABEL,
        BINARY_EXPRESSION(EXPRESSION),
        LEFT_OPERAND(EXPRESSION),
        RIGHT_OPERAND(EXPRESSION),
        PARENTHESIZED_EXPRESSION,
        ARRAY_ACCESS_EXPRESSION,
        ARRAY_OBJECT_EXPRESSION,
        ARRAY_KEY_EXPRESSION,
        LEFT_PARENTHESIS,
        RIGHT_PARENTHESIS,
        BLOCK,
        BODY,
        GOTO(UNCONDITIONAL_JUMP),
        BRANCH_LABEL,
        BREAK(UNCONDITIONAL_JUMP),
        CASE,
        CLASS,
        COMMENT,
        CONTINUE(UNCONDITIONAL_JUMP),
        DEFAULT_CASE,
        STRUCTURED_COMMENT(COMMENT),
        PACKAGE,
        CALL,
        MEMBER_SELECT,
        FALLTHROUGH(UNCONDITIONAL_JUMP),
        COMPILATION_UNIT,
        CONDITION,
        ELSE,
        ELSE_KEYWORD,
        EOF,
        CONSTRUCTOR,
        FUNCTION,
        FUNCTION_NAME,
        VARIABLE_DECLARATION,
        CONSTANT_DECLARATION(VARIABLE_DECLARATION),
        VARIABLE_NAME,
        IMPORT,
        IMPORT_ENTRY,
        FUNCTION_LITERAL(EXPRESSION),
        IDENTIFIER,
        IF(CONDITIONAL_JUMP),
        IF_KEYWORD,
        KEYWORD,
        LITERAL,
        FLOAT_LITERAL(LITERAL),
        INT_LITERAL(LITERAL),
        DECIMAL_LITERAL(LITERAL),
        HEX_LITERAL(LITERAL),
        OCTAL_LITERAL(LITERAL),
        BINARY_LITERAL(LITERAL),
        STRING_LITERAL(LITERAL),
        CHAR_LITERAL(LITERAL),
        BOOLEAN_LITERAL(LITERAL),
        NULL_LITERAL(LITERAL),
        LOOP(CONDITIONAL_JUMP),
        FOR(LOOP),
        FOR_KEYWORD,
        FOR_INIT,
        FOR_UPDATE,
        FOREACH(LOOP),
        PARAMETER(VARIABLE_DECLARATION),
        PARAMETER_LIST,
        OPERATOR,
        ADD(BINARY_EXPRESSION),
        SUBTRACT(BINARY_EXPRESSION),
        MULTIPLY(BINARY_EXPRESSION),
        DIVIDE(BINARY_EXPRESSION),
        REMAINDER(BINARY_EXPRESSION),
        BITWISE_AND(BINARY_EXPRESSION),
        BITWISE_AND_NOT(BINARY_EXPRESSION),
        BITWISE_OR(BINARY_EXPRESSION),
        BITWISE_XOR(BINARY_EXPRESSION),
        LEFT_SHIFT(BINARY_EXPRESSION),
        RIGHT_SHIFT(BINARY_EXPRESSION),
        EQUAL(BINARY_EXPRESSION),
        LOGICAL_AND(BINARY_EXPRESSION),
        LOGICAL_OR(BINARY_EXPRESSION),
        NOT_EQUAL(BINARY_EXPRESSION),
        LESS_THAN(BINARY_EXPRESSION),
        LESS_OR_EQUAL(BINARY_EXPRESSION),
        GREATER_THAN(BINARY_EXPRESSION),
        GREATER_OR_EQUAL(BINARY_EXPRESSION),
        RETURN(UNCONDITIONAL_JUMP),
        RESULT_LIST,
        STATEMENT,
        EMPTY_STATEMENT(STATEMENT),
        SWITCH(CONDITIONAL_JUMP),
        THEN,
        THROW(UNCONDITIONAL_JUMP),
        TYPE,
        UNSUPPORTED,
        ASSIGNMENT,
        ASSIGNMENT_OPERATOR,
        ASSIGNMENT_TARGET_LIST,
        ASSIGNMENT_TARGET,
        ASSIGNMENT_VALUE_LIST,
        ASSIGNMENT_VALUE,
        COMPOUND_ASSIGNMENT(ASSIGNMENT),
        PLUS_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        MINUS_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        MULTIPLY_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        OR_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        AND_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        AND_NOT_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        XOR_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        DIVIDE_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        REMAINDER_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        LEFT_SHIFT_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        RIGHT_SHIFT_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        UNSIGNED_RIGHT_SHIFT_ASSIGNMENT(COMPOUND_ASSIGNMENT),
        UNARY_EXPRESSION(EXPRESSION),
        OPERAND,
        UNARY_MINUS(UNARY_EXPRESSION),
        UNARY_PLUS(UNARY_EXPRESSION),
        POSTFIX_DECREMENT(UNARY_EXPRESSION),
        POSTFIX_INCREMENT(UNARY_EXPRESSION),
        PREFIX_DECREMENT(UNARY_EXPRESSION),
        PREFIX_INCREMENT(UNARY_EXPRESSION),
        LOGICAL_COMPLEMENT(UNARY_EXPRESSION),
        BITWISE_COMPLEMENT(UNARY_EXPRESSION),
        POINTER(UNARY_EXPRESSION),
        REFERENCE(UNARY_EXPRESSION),
        CHANNEL_DIRECTION(UNARY_EXPRESSION),
        ANNOTATION,
        ANNOTATION_TYPE,
        ARGUMENTS,
        ARGUMENT,
        ASSERT,
        CATCH,
        CONDITIONAL_EXPRESSION,
        TYPE_ARGUMENTS,
        TYPE_ARGUMENT,
        TYPE_PARAMETERS,
        TYPE_PARAMETER,
        WHILE(LOOP),
        DO_WHILE(LOOP),
        CAST,
        ENUM,
        INITIALIZER,
        TYPE_TEST,
        TRY(CONDITIONAL_JUMP);

        private final Set<Kind> extendedKinds;

        private Kind() {
            this.extendedKinds = Collections.emptySet();
        }

        private Kind(Kind ... extendedKinds) {
            this.extendedKinds = Arrays.stream(extendedKinds).flatMap(Kind::kindAndExtendedKindStream).collect(Collectors.toSet());
        }

        public Set<Kind> extendedKinds() {
            return this.extendedKinds;
        }

        public Stream<Kind> kindAndExtendedKindStream() {
            if (this.extendedKinds.isEmpty()) {
                return Stream.of(this);
            }
            return Stream.concat(Stream.of(this), this.extendedKinds.stream());
        }

        @Override
        public boolean test(UastNode uastNode) {
            return uastNode.kinds.contains(this);
        }
    }

    public static class Token {
        private static final Pattern LINE_SPLITTER = Pattern.compile("\r\n|\n|\r");
        public final String value;
        public final int line;
        public final int column;
        public final int endLine;
        public final int endColumn;

        public Token(int line, int column, String value) {
            if (line < 1 || column < 1) {
                throw new IllegalArgumentException("Invalid token location " + line + ":" + column);
            }
            this.line = line;
            this.column = column;
            this.value = value;
            if (value.indexOf(10) == -1 && value.indexOf(13) == -1) {
                this.endLine = line;
                this.endColumn = column + Token.codePointCount(value) - 1;
            } else {
                String[] lines = LINE_SPLITTER.split(value, -1);
                this.endLine = line + lines.length - 1;
                this.endColumn = Token.codePointCount(lines[lines.length - 1]);
            }
        }

        private static int codePointCount(String s) {
            return s.codePointCount(0, s.length());
        }

        public String toString() {
            return "[" + this.line + ":" + this.column + " " + this.value + "]";
        }
    }
}

