/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ClientNonSmartListenerService
extends ClientListenerServiceImpl
implements ConnectionListener {
    private final Map<ClientRegistrationKey, ClientEventRegistration> activeRegistrations = new ConcurrentHashMap<ClientRegistrationKey, ClientEventRegistration>();
    private final Set<ClientRegistrationKey> userRegistrations = new HashSet<ClientRegistrationKey>();

    public ClientNonSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        assert (!Thread.currentThread().getName().contains("eventRegistration"));
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                try {
                    ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(registrationKey);
                    ClientNonSmartListenerService.this.activeRegistrations.put(registrationKey, registration);
                    ClientNonSmartListenerService.this.userRegistrations.add(registrationKey);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener can not be added", (Throwable)e);
                }
                return userRegistrationId;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientEventRegistration invoke(ClientRegistrationKey registrationKey) throws Exception {
        assert (Thread.currentThread().getName().contains("eventRegistration"));
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientMessage request = registrationKey.getCodec().encodeAddRequest(false);
        ClientInvocation invocation = new ClientInvocation(this.client, request);
        invocation.setEventHandler(handler);
        ClientInvocationFuture future = invocation.invoke();
        String registrationId = registrationKey.getCodec().decodeAddResponse((ClientMessage)future.get());
        handler.onListenerRegister();
        ClientConnection connection = future.getInvocation().getSendConnection();
        return new ClientEventRegistration(registrationId, request.getCorrelationId(), (Connection)connection, registrationKey.getCodec());
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        assert (!Thread.currentThread().getName().contains("eventRegistration"));
        Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                if (!ClientNonSmartListenerService.this.userRegistrations.remove(key)) {
                    return false;
                }
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.activeRegistrations.get(key);
                if (registration == null) {
                    return true;
                }
                ClientMessage request = registration.getCodec().encodeRemoveRequest(registration.getServerRegistrationId());
                try {
                    ClientInvocationFuture future = new ClientInvocation(ClientNonSmartListenerService.this.client, request).invoke();
                    future.get();
                    ClientNonSmartListenerService.this.removeEventHandler(registration.getCallId());
                    ClientNonSmartListenerService.this.activeRegistrations.remove(key);
                }
                catch (Exception e) {
                    throw new HazelcastException("Listener with ID " + userRegistrationId + " could not be removed", (Throwable)e);
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public void start() {
        this.client.getConnectionManager().addConnectionListener(this);
    }

    public void connectionAdded(final Connection connection) {
        assert (!Thread.currentThread().getName().contains("eventRegistration"));
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClientRegistrationKey registrationKey : ClientNonSmartListenerService.this.userRegistrations) {
                    try {
                        ClientEventRegistration oldRegistration = (ClientEventRegistration)ClientNonSmartListenerService.this.activeRegistrations.get(registrationKey);
                        if (oldRegistration != null) {
                            ClientNonSmartListenerService.this.removeEventHandler(oldRegistration.getCallId());
                        }
                        ClientEventRegistration eventRegistration = ClientNonSmartListenerService.this.invoke(registrationKey);
                        ClientNonSmartListenerService.this.activeRegistrations.put(registrationKey, eventRegistration);
                    }
                    catch (Exception e) {
                        ClientNonSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not be added to new connection: " + connection, (Throwable)e);
                    }
                }
            }
        });
    }

    public void connectionRemoved(Connection connection) {
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        assert (!Thread.currentThread().getName().contains("eventRegistration"));
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() throws Exception {
                ClientEventRegistration registration = (ClientEventRegistration)ClientNonSmartListenerService.this.activeRegistrations.get(new ClientRegistrationKey(uuid));
                if (registration == null || !registration.getSubscriber().isAlive()) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                activeRegistrations.add(registration);
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

