/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scm.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.scm.git.AnalysisWarningsWrapper;
import org.sonarsource.scm.git.ChangedLinesComputer;
import org.sonarsource.scm.git.JGitBlameCommand;

public class GitScmProviderBefore77
extends ScmProvider {
    private static final Logger LOG = Loggers.get(GitScmProviderBefore77.class);
    private final JGitBlameCommand jgitBlameCommand;
    private final AnalysisWarningsWrapper analysisWarnings;

    public GitScmProviderBefore77(JGitBlameCommand jgitBlameCommand, AnalysisWarningsWrapper analysisWarnings) {
        this.jgitBlameCommand = jgitBlameCommand;
        this.analysisWarnings = analysisWarnings;
    }

    public String key() {
        return "git";
    }

    public boolean supports(File baseDir) {
        RepositoryBuilder builder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(baseDir);
        return builder.getGitDir() != null;
    }

    public BlameCommand blameCommand() {
        return this.jgitBlameCommand;
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLines(String targetBranchName, Path projectBaseDir, Set<Path> changedFiles) {
        try (Repository repo = this.buildRepo(projectBaseDir);){
            Ref targetRef = this.resolveTargetRef(targetBranchName, repo);
            if (targetRef == null) {
                Map<Path, Set<Integer>> map = null;
                return map;
            }
            HashMap<Path, Set<Integer>> changedLines = new HashMap<Path, Set<Integer>>();
            try (Git git = this.newGit(repo);){
                for (Path path : changedFiles) {
                    ChangedLinesComputer computer = new ChangedLinesComputer();
                    Path repoRootDir = repo.getDirectory().toPath().getParent();
                    try {
                        Object diffEntries = git.diff().setOutputStream(computer.receiver()).setOldTree(this.prepareTreeParser(repo, targetRef)).setPathFilter(PathFilter.create(GitScmProviderBefore77.toGitPath(repoRootDir.relativize(path).toString()))).call();
                        diffEntries.stream().filter(diffEntry -> diffEntry.getChangeType() == DiffEntry.ChangeType.ADD || diffEntry.getChangeType() == DiffEntry.ChangeType.MODIFY).forEach(diffEntry -> changedLines.put(path, computer.changedLines()));
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to get changed lines from git for file " + path, (Throwable)e);
                    }
                }
            }
            HashMap<Path, Set<Integer>> hashMap = changedLines;
            return hashMap;
        }
        catch (Exception e) {
            LOG.warn("Failed to get changed lines from git", (Throwable)e);
            return null;
        }
    }

    private static String toGitPath(String path) {
        return path.replaceAll(Pattern.quote(File.separator), "/");
    }

    @CheckForNull
    private Ref resolveTargetRef(String targetBranchName, Repository repo) throws IOException {
        Ref targetRef = repo.exactRef("refs/heads/" + targetBranchName);
        if (targetRef == null) {
            targetRef = repo.exactRef("refs/remotes/origin/" + targetBranchName);
        }
        if (targetRef == null) {
            LOG.warn("Could not find ref: {} in refs/heads or refs/remotes/origin", (Object)targetBranchName);
            this.analysisWarnings.addUnique(String.format("Could not find ref '%s' in refs/heads or refs/remotes/origin. You may see unexpected issues and changes. Please make sure to fetch this ref before pull request analysis.", targetBranchName));
            return null;
        }
        return targetRef;
    }

    public Path relativePathFromScmRoot(Path path) {
        RepositoryBuilder builder = GitScmProviderBefore77.getVerifiedRepositoryBuilder(path);
        return builder.getGitDir().toPath().getParent().relativize(path);
    }

    public String revisionId(Path path) {
        RepositoryBuilder builder = GitScmProviderBefore77.getVerifiedRepositoryBuilder(path);
        try {
            return GitScmProviderBefore77.getHead(builder.build()).getObjectId().getName();
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error while getting revision ID for path: " + path, e);
        }
    }

    private static AbstractTreeIterator prepareNewTree(Repository repo) throws IOException {
        CanonicalTreeParser treeParser = new CanonicalTreeParser();
        try (ObjectReader objectReader = repo.newObjectReader();){
            treeParser.reset(objectReader, repo.parseCommit(GitScmProviderBefore77.getHead(repo).getObjectId()).getTree());
        }
        return treeParser;
    }

    private static Ref getHead(Repository repo) throws IOException {
        return repo.exactRef("HEAD");
    }

    private AbstractTreeIterator prepareTreeParser(Repository repo, Ref targetRef) throws IOException {
        try (RevWalk walk = this.newRevWalk(repo);){
            walk.markStart(walk.parseCommit(targetRef.getObjectId()));
            walk.markStart(walk.parseCommit(GitScmProviderBefore77.getHead(repo).getObjectId()));
            walk.setRevFilter(RevFilter.MERGE_BASE);
            RevCommit base = walk.parseCommit(walk.next());
            LOG.debug("Merge base sha1: {}", (Object)base.getName());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader objectReader = repo.newObjectReader();){
                treeParser.reset(objectReader, base.getTree());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    Git newGit(Repository repo) {
        return new Git(repo);
    }

    RevWalk newRevWalk(Repository repo) {
        return new RevWalk(repo);
    }

    Repository buildRepo(Path basedir) throws IOException {
        return GitScmProviderBefore77.getVerifiedRepositoryBuilder(basedir).build();
    }

    static RepositoryBuilder getVerifiedRepositoryBuilder(Path basedir) {
        RepositoryBuilder builder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().findGitDir(basedir.toFile())).setMustExist(true);
        if (builder.getGitDir() == null) {
            throw MessageException.of((String)("Not inside a Git work tree: " + basedir));
        }
        return builder;
    }

    private static /* synthetic */ Path lambda$branchChangedFiles$1(Repository repo, DiffEntry diffEntry) {
        return repo.getWorkTree().toPath().resolve(diffEntry.getNewPath());
    }

    private static /* synthetic */ boolean lambda$branchChangedFiles$0(DiffEntry diffEntry) {
        return diffEntry.getChangeType() == DiffEntry.ChangeType.ADD || diffEntry.getChangeType() == DiffEntry.ChangeType.MODIFY;
    }
}

