/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;

public class DotCoverReportParser
implements CoverageParser {
    private static final Logger LOG = Loggers.get(DotCoverReportParser.class);
    private final Predicate<String> isSupportedLanguage;

    public DotCoverReportParser(Predicate<String> isSupportedLanguage) {
        this.isSupportedLanguage = isSupportedLanguage;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.info("Parsing the dotCover report " + file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final Pattern TITLE_PATTERN = Pattern.compile(".*?<title>(.*?)</title>.*", 32);
        private final Pattern COVERED_LINES_PATTERN_1 = Pattern.compile(".*<script type=\"text/javascript\">\\s*+highlightRanges\\(\\[(.*?)\\]\\);\\s*+</script>.*", 32);
        private final Pattern COVERED_LINES_PATTERN_2 = Pattern.compile("\\[(\\d++),\\d++,\\d++,\\d++,(\\d++)\\]");
        private final File file;
        private final Coverage coverage;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            String contents;
            try {
                contents = new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            String fileCanonicalPath = this.extractFileCanonicalPath(contents);
            if (fileCanonicalPath != null && DotCoverReportParser.this.isSupportedLanguage.test(fileCanonicalPath)) {
                this.collectCoverage(fileCanonicalPath, contents);
            }
        }

        @Nullable
        private String extractFileCanonicalPath(String contents) {
            Matcher matcher = this.TITLE_PATTERN.matcher(contents);
            this.checkMatches(matcher);
            String lowerCaseAbsolutePath = matcher.group(1);
            try {
                return new File(lowerCaseAbsolutePath).getCanonicalPath();
            }
            catch (IOException e) {
                LOG.debug("Skipping the import of dotCover code coverage for the invalid file path: " + lowerCaseAbsolutePath, (Object)e);
                return null;
            }
        }

        private void collectCoverage(String fileCanonicalPath, String contents) {
            Matcher matcher = this.COVERED_LINES_PATTERN_1.matcher(contents);
            this.checkMatches(matcher);
            String highlightedContents = matcher.group(1);
            matcher = this.COVERED_LINES_PATTERN_2.matcher(highlightedContents);
            while (matcher.find()) {
                int line = Integer.parseInt(matcher.group(1));
                int hits = Integer.parseInt(matcher.group(2));
                this.coverage.addHits(fileCanonicalPath, line, hits);
            }
        }

        private void checkMatches(Matcher matcher) {
            if (!matcher.matches()) {
                throw new IllegalArgumentException("The report contents does not match the following regular expression: " + matcher.pattern().pattern());
            }
        }
    }
}

