/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class OpenCoverReportParser
implements CoverageParser {
    private static final Logger LOG = Loggers.get(OpenCoverReportParser.class);
    private final Predicate<String> isSupportedLanguage;

    public OpenCoverReportParser(Predicate<String> isSupportedLanguage) {
        this.isSupportedLanguage = isSupportedLanguage;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.info("Parsing the OpenCover report " + file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final File file;
        private final Map<String, String> files = new HashMap<String, String>();
        private final Coverage coverage;
        private String fileRef;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                xmlParserHelper.checkRootTag("CoverageSession");
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("File".equals(tagName)) {
                    this.handleFileTag(xmlParserHelper);
                    continue;
                }
                if ("FileRef".equals(tagName)) {
                    this.handleFileRef(xmlParserHelper);
                    continue;
                }
                if (!"SequencePoint".equals(tagName)) continue;
                this.handleSegmentPointTag(xmlParserHelper);
            }
        }

        private void handleFileRef(XmlParserHelper xmlParserHelper) {
            this.fileRef = xmlParserHelper.getRequiredAttribute("uid");
        }

        private void handleFileTag(XmlParserHelper xmlParserHelper) {
            String uid = xmlParserHelper.getRequiredAttribute("uid");
            String fullPath = xmlParserHelper.getRequiredAttribute("fullPath");
            try {
                this.files.put(uid, new File(fullPath).getCanonicalPath());
            }
            catch (IOException e) {
                LOG.debug("Skipping the import of OpenCover code coverage for the invalid file path: " + fullPath + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Object)e);
            }
        }

        private void handleSegmentPointTag(XmlParserHelper xmlParserHelper) {
            int line = xmlParserHelper.getRequiredIntAttribute("sl");
            int vc = xmlParserHelper.getRequiredIntAttribute("vc");
            String fileId = xmlParserHelper.getAttribute("fileid");
            if (fileId == null) {
                fileId = this.fileRef;
            }
            if (this.files.containsKey(fileId)) {
                String file = this.files.get(fileId);
                if (OpenCoverReportParser.this.isSupportedLanguage.test(file)) {
                    this.coverage.addHits(file, line, vc);
                }
            }
        }
    }
}

