/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.protobuf.EncodingImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.FileMetadataImporter;

@Phase(name=Phase.Name.POST)
public abstract class AbstractGlobalProtobufFileProcessor
extends ProjectBuilder {
    private static final Logger LOG = Loggers.get(AbstractGlobalProtobufFileProcessor.class);
    private final String languageKey;
    private final Map<Path, Charset> roslynEncodingPerPath = new HashMap<Path, Charset>();
    private final Set<Path> generatedFilePaths = new HashSet<Path>();

    public AbstractGlobalProtobufFileProcessor(String languageKey) {
        this.languageKey = languageKey;
    }

    public void build(ProjectBuilder.Context context) {
        for (ProjectDefinition p : context.projectReactor().getProjects()) {
            for (Path reportPath : this.protobufReportPaths(p.properties())) {
                this.processEncodingReportIfPresent(reportPath);
                this.processMetadataReportIfPresent(reportPath);
            }
        }
    }

    private void processEncodingReportIfPresent(Path reportPath) {
        Path encodingReportProtobuf = reportPath.resolve("encoding.pb");
        if (encodingReportProtobuf.toFile().exists()) {
            LOG.debug("Processing {}", (Object)encodingReportProtobuf);
            EncodingImporter encodingImporter = new EncodingImporter();
            encodingImporter.accept(encodingReportProtobuf);
            this.roslynEncodingPerPath.putAll(encodingImporter.getEncodingPerPath());
        }
    }

    private void processMetadataReportIfPresent(Path reportPath) {
        Path metadataReportProtobuf = reportPath.resolve("file-metadata.pb");
        if (metadataReportProtobuf.toFile().exists()) {
            LOG.debug("Processing {}", (Object)metadataReportProtobuf);
            FileMetadataImporter fileMetadataImporter = new FileMetadataImporter();
            fileMetadataImporter.accept(metadataReportProtobuf);
            this.generatedFilePaths.addAll(fileMetadataImporter.getGeneratedFilePaths());
        }
    }

    public Map<Path, Charset> getRoslynEncodingPerPath() {
        return Collections.unmodifiableMap(this.roslynEncodingPerPath);
    }

    public Set<Path> getGeneratedFilePaths() {
        return Collections.unmodifiableSet(this.generatedFilePaths);
    }

    private List<Path> protobufReportPaths(Map<String, String> moduleProps) {
        List analyzerWorkDirPaths = Arrays.stream(this.parseAsStringArray(moduleProps.get(AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.languageKey)))).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        if (analyzerWorkDirPaths.isEmpty()) {
            Optional<String> oldValue = Optional.ofNullable(moduleProps.get(AbstractConfiguration.getOldAnalyzerWorkDirProperty(this.languageKey)));
            analyzerWorkDirPaths = oldValue.map(x$0 -> Paths.get(x$0, new String[0])).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return analyzerWorkDirPaths.stream().map(x -> x.resolve(AbstractConfiguration.getAnalyzerReportDir(this.languageKey))).collect(Collectors.toList());
    }

    private String[] parseAsStringArray(@Nullable String value) {
        if (value == null) {
            return new String[0];
        }
        List<String> escapedValues = Arrays.asList(value.split(","));
        return (String[])escapedValues.stream().map(String::trim).map(s -> AbstractGlobalProtobufFileProcessor.removeStart(s, "\"")).map(s -> AbstractGlobalProtobufFileProcessor.removeEnd(s, "\"")).toArray(String[]::new);
    }

    private static String removeStart(String s, String start) {
        return s.startsWith(start) ? s.substring(start.length()) : s;
    }

    private static String removeEnd(String s, String end) {
        return s.endsWith(end) ? s.substring(0, s.length() - end.length()) : s;
    }
}

