/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.plugins.SarifParserCallbackImpl;
import org.sonarsource.dotnet.shared.sarif.SarifParserFactory;

@ScannerSide
public class RoslynDataImporter {
    private static final Logger LOG = Loggers.get(RoslynDataImporter.class);
    private final AbstractConfiguration config;

    public RoslynDataImporter(AbstractConfiguration config) {
        this.config = config;
    }

    public void importRoslynReports(List<RoslynReport> reportPaths, SensorContext context, Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey, Function<String, String> toRealPath) {
        Map<String, String> repositoryKeyByRoslynRuleKey = RoslynDataImporter.getRepoKeyByRoslynRuleKey(activeRoslynRulesByPartialRepoKey);
        boolean ignoreThirdPartyIssues = this.config.ignoreThirdPartyIssues() || !context.runtime().getApiVersion().isGreaterThanOrEqual(Version.create((int)7, (int)4));
        SarifParserCallbackImpl callback = new SarifParserCallbackImpl(context, repositoryKeyByRoslynRuleKey, ignoreThirdPartyIssues, this.config.bugCategories(), this.config.codeSmellCategories(), this.config.vulnerabilityCategories());
        LOG.info("Importing {} Roslyn {}", (Object)reportPaths.size(), (Object)RoslynDataImporter.pluralize("report", reportPaths.size()));
        for (RoslynReport report : reportPaths) {
            SarifParserFactory.create(report, toRealPath).accept(callback);
        }
    }

    private static Map<String, String> getRepoKeyByRoslynRuleKey(Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey) {
        HashMap<String, String> repositoryKeyByRoslynRuleKey = new HashMap<String, String>();
        for (List<RuleKey> rules : activeRoslynRulesByPartialRepoKey.values()) {
            for (RuleKey activeRoslynRuleKey : rules) {
                String previousRepositoryKey = repositoryKeyByRoslynRuleKey.put(activeRoslynRuleKey.rule(), activeRoslynRuleKey.repository());
                if (previousRepositoryKey == null) continue;
                throw new IllegalArgumentException("Rule keys must be unique, but \"" + activeRoslynRuleKey.rule() + "\" is defined in both the \"" + previousRepositoryKey + "\" and \"" + activeRoslynRuleKey.repository() + "\" rule repositories.");
            }
        }
        return repositoryKeyByRoslynRuleKey;
    }

    private static String pluralize(String s, int count) {
        return count == 1 ? s : s + "s";
    }
}

