/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DatabaseUtils {
    public static final int PARTITION_SIZE_FOR_ORACLE = 1000;
    private static final String[] TABLE_TYPE = new String[]{"TABLE"};

    protected DatabaseUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void closeQuietly(@Nullable Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                Loggers.get(DatabaseUtils.class).warn("Fail to close connection", (Throwable)e);
            }
        }
    }

    public static void closeQuietly(@Nullable Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                Loggers.get(DatabaseUtils.class).warn("Fail to close statement", (Throwable)e);
            }
        }
    }

    public static void closeQuietly(@Nullable ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                Loggers.get(DatabaseUtils.class).warn("Fail to close result set", (Throwable)e);
            }
        }
    }

    public static <OUTPUT, INPUT extends Comparable<INPUT>> List<OUTPUT> executeLargeInputs(Collection<INPUT> input, Function<List<INPUT>, List<OUTPUT>> function) {
        return DatabaseUtils.executeLargeInputs(input, function, i -> i);
    }

    public static <OUTPUT, INPUT extends Comparable<INPUT>> List<OUTPUT> executeLargeInputs(Collection<INPUT> input, Function<List<INPUT>, List<OUTPUT>> function, IntFunction<Integer> partitionSizeManipulations) {
        return DatabaseUtils.executeLargeInputs(input, function, size -> size == 0 ? Collections.emptyList() : new ArrayList(size), partitionSizeManipulations);
    }

    public static <OUTPUT, INPUT extends Comparable<INPUT>> Set<OUTPUT> executeLargeInputsIntoSet(Collection<INPUT> input, Function<List<INPUT>, Set<OUTPUT>> function, IntFunction<Integer> partitionSizeManipulations) {
        return DatabaseUtils.executeLargeInputs(input, function, size -> size == 0 ? Collections.emptySet() : new HashSet(size), partitionSizeManipulations);
    }

    private static <OUTPUT, INPUT extends Comparable<INPUT>, RESULT extends Collection<OUTPUT>> RESULT executeLargeInputs(Collection<INPUT> input, Function<List<INPUT>, RESULT> function, IntFunction<RESULT> outputInitializer, IntFunction<Integer> partitionSizeManipulations) {
        if (input.isEmpty()) {
            return (RESULT)((Collection)outputInitializer.apply(0));
        }
        Collection results = (Collection)outputInitializer.apply(input.size());
        for (List<INPUT> partition : DatabaseUtils.toUniqueAndSortedPartitions(input, partitionSizeManipulations)) {
            Collection subResults = (Collection)function.apply(partition);
            if (subResults == null) continue;
            results.addAll(subResults);
        }
        return (RESULT)results;
    }

    public static <INPUT extends Comparable<INPUT>> void executeLargeUpdates(Collection<INPUT> inputs, Consumer<List<INPUT>> consumer) {
        DatabaseUtils.executeLargeUpdates(inputs, consumer, i -> i);
    }

    public static <INPUT extends Comparable<INPUT>> void executeLargeUpdates(Collection<INPUT> inputs, Consumer<List<INPUT>> consumer, IntFunction<Integer> partitionSizeManipulations) {
        Iterable<List<INPUT>> partitions = DatabaseUtils.toUniqueAndSortedPartitions(inputs, partitionSizeManipulations);
        for (List<INPUT> partition : partitions) {
            consumer.accept(partition);
        }
    }

    public static <INPUT extends Comparable<INPUT>> Iterable<List<INPUT>> toUniqueAndSortedPartitions(Collection<INPUT> inputs) {
        return DatabaseUtils.toUniqueAndSortedPartitions(inputs, i -> i);
    }

    public static <INPUT extends Comparable<INPUT>> Iterable<List<INPUT>> toUniqueAndSortedPartitions(Collection<INPUT> inputs, IntFunction<Integer> partitionSizeManipulations) {
        int partitionSize = partitionSizeManipulations.apply(1000);
        return Iterables.partition(DatabaseUtils.toUniqueAndSortedList(inputs), (int)partitionSize);
    }

    public static <INPUT extends Comparable<INPUT>> List<INPUT> toUniqueAndSortedList(Iterable<INPUT> inputs) {
        if (inputs instanceof Set) {
            return Ordering.natural().immutableSortedCopy(inputs);
        }
        return Ordering.natural().immutableSortedCopy((Iterable)Sets.newHashSet(inputs));
    }

    public static <T> void executeLargeInputsWithoutOutput(Collection<T> input, Consumer<List<T>> consumer) {
        if (input.isEmpty()) {
            return;
        }
        List partitions = Lists.partition((List)Lists.newArrayList(input), (int)1000);
        for (List partition : partitions) {
            consumer.accept(partition);
        }
    }

    public static void log(Logger logger, SQLException e) {
        for (SQLException next = e.getNextException(); next != null; next = next.getNextException()) {
            logger.error("SQL error: {}. Message: {}", (Object)next.getSQLState(), (Object)next.getMessage());
        }
    }

    @CheckForNull
    public static Long getLong(ResultSet rs, String columnName) throws SQLException {
        long l = rs.getLong(columnName);
        return rs.wasNull() ? null : Long.valueOf(l);
    }

    @CheckForNull
    public static Double getDouble(ResultSet rs, String columnName) throws SQLException {
        double d = rs.getDouble(columnName);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    @CheckForNull
    public static Integer getInt(ResultSet rs, String columnName) throws SQLException {
        int i = rs.getInt(columnName);
        return rs.wasNull() ? null : Integer.valueOf(i);
    }

    @CheckForNull
    public static String getString(ResultSet rs, String columnName) throws SQLException {
        String s = rs.getString(columnName);
        return rs.wasNull() ? null : s;
    }

    @CheckForNull
    public static Long getLong(ResultSet rs, int columnIndex) throws SQLException {
        long l = rs.getLong(columnIndex);
        return rs.wasNull() ? null : Long.valueOf(l);
    }

    @CheckForNull
    public static Double getDouble(ResultSet rs, int columnIndex) throws SQLException {
        double d = rs.getDouble(columnIndex);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    @CheckForNull
    public static Integer getInt(ResultSet rs, int columnIndex) throws SQLException {
        int i = rs.getInt(columnIndex);
        return rs.wasNull() ? null : Integer.valueOf(i);
    }

    @CheckForNull
    public static String getString(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        return rs.wasNull() ? null : s;
    }

    @CheckForNull
    public static Date getDate(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp t = rs.getTimestamp(columnIndex);
        return rs.wasNull() ? null : new Date(t.getTime());
    }

    public static boolean tableExists(String table, Connection connection) {
        return DatabaseUtils.doTableExists(table, connection) || DatabaseUtils.doTableExists(table.toLowerCase(Locale.ENGLISH), connection) || DatabaseUtils.doTableExists(table.toUpperCase(Locale.ENGLISH), connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doTableExists(String table, Connection connection) {
        String schema = null;
        try {
            if (!"H2 JDBC Driver".equals(connection.getMetaData().getDriverName())) {
                schema = connection.getSchema();
            }
        }
        catch (SQLException e) {
            Loggers.get(DatabaseUtils.class).warn("Fail to determine schema. Keeping it null for searching tables", (Throwable)e);
        }
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), schema, table, TABLE_TYPE);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (!table.equalsIgnoreCase(name)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw DatabaseUtils.wrapSqlException(e, "Can not check that table %s exists", table);
        }
    }

    public static IllegalStateException wrapSqlException(SQLException e, String message, Object ... messageArgs) {
        return new IllegalStateException(String.format(message, messageArgs), e);
    }

    public static Consumer<String> setStrings(PreparedStatement stmt, Supplier<Integer> index) {
        return value -> {
            try {
                stmt.setString((Integer)index.get(), (String)value);
            }
            catch (SQLException e) {
                Throwables.propagate((Throwable)e);
            }
        };
    }

    public static void checkThatNotTooManyConditions(@Nullable Collection<?> values, String message) {
        if (values != null) {
            Preconditions.checkArgument((values.size() <= 1000 ? 1 : 0) != 0, (Object)message);
        }
    }
}

