/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import java.sql.DatabaseMetaData;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.dialect.AbstractDialect;

public class H2
extends AbstractDialect {
    public static final String ID = "h2";

    public H2() {
        super(ID, "org.h2.Driver", "true", "false", "SELECT 1");
    }

    @Override
    public boolean matchesJdbcUrl(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:h2:");
    }

    @Override
    public boolean supportsMigration() {
        return false;
    }

    @Override
    public void init(DatabaseMetaData metaData) {
        Loggers.get(this.getClass()).warn("H2 database should be used for evaluation purpose only.");
    }
}

