/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.dbcp2.BasicDataSource;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.profiling.ConnectionInterceptor;

public class ProfiledDataSource
extends BasicDataSource {
    static final Logger SQL_LOGGER = Loggers.get((String)"sql");
    private final BasicDataSource delegate;
    private ConnectionInterceptor connectionInterceptor;

    public ProfiledDataSource(BasicDataSource delegate, ConnectionInterceptor connectionInterceptor) {
        this.delegate = delegate;
        this.connectionInterceptor = connectionInterceptor;
    }

    public BasicDataSource getDelegate() {
        return this.delegate;
    }

    public synchronized void setConnectionInterceptor(ConnectionInterceptor ci) {
        this.connectionInterceptor = ci;
    }

    public Boolean getDefaultAutoCommit() {
        return this.delegate.getDefaultAutoCommit();
    }

    public Boolean getDefaultReadOnly() {
        return this.delegate.getDefaultReadOnly();
    }

    public int getDefaultTransactionIsolation() {
        return this.delegate.getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.delegate.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public String getDefaultCatalog() {
        return this.delegate.getDefaultCatalog();
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.delegate.setDefaultCatalog(defaultCatalog);
    }

    public synchronized String getDriverClassName() {
        return this.delegate.getDriverClassName();
    }

    public synchronized void setDriverClassName(String driverClassName) {
        this.delegate.setDriverClassName(driverClassName);
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.delegate.getDriverClassLoader();
    }

    public synchronized void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.delegate.setDriverClassLoader(driverClassLoader);
    }

    public synchronized int getMaxTotal() {
        return this.delegate.getMaxTotal();
    }

    public synchronized void setMaxTotal(int maxActive) {
        this.delegate.setMaxTotal(maxActive);
    }

    public synchronized int getMaxIdle() {
        return this.delegate.getMaxIdle();
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.delegate.setMaxIdle(maxIdle);
    }

    public synchronized int getMinIdle() {
        return this.delegate.getMinIdle();
    }

    public synchronized void setMinIdle(int minIdle) {
        this.delegate.setMinIdle(minIdle);
    }

    public synchronized int getInitialSize() {
        return this.delegate.getInitialSize();
    }

    public synchronized void setInitialSize(int initialSize) {
        this.delegate.setInitialSize(initialSize);
    }

    public synchronized long getMaxWaitMillis() {
        return this.delegate.getMaxWaitMillis();
    }

    public synchronized void setMaxWaitMillis(long maxWait) {
        this.delegate.setMaxWaitMillis(maxWait);
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.delegate.isPoolPreparedStatements();
    }

    public synchronized void setPoolPreparedStatements(boolean poolingStatements) {
        this.delegate.setPoolPreparedStatements(poolingStatements);
    }

    public synchronized int getMaxOpenPreparedStatements() {
        return this.delegate.getMaxOpenPreparedStatements();
    }

    public synchronized void setMaxOpenPreparedStatements(int maxOpenStatements) {
        this.delegate.setMaxOpenPreparedStatements(maxOpenStatements);
    }

    public synchronized boolean getTestOnBorrow() {
        return this.delegate.getTestOnBorrow();
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.delegate.setTestOnBorrow(testOnBorrow);
    }

    public synchronized boolean getTestOnReturn() {
        return this.delegate.getTestOnReturn();
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.delegate.setTestOnReturn(testOnReturn);
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.delegate.getTimeBetweenEvictionRunsMillis();
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.delegate.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.delegate.getNumTestsPerEvictionRun();
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.delegate.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.delegate.getMinEvictableIdleTimeMillis();
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.delegate.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public synchronized boolean getTestWhileIdle() {
        return this.delegate.getTestWhileIdle();
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.delegate.setTestWhileIdle(testWhileIdle);
    }

    public synchronized int getNumActive() {
        return this.delegate.getNumActive();
    }

    public synchronized int getNumIdle() {
        return this.delegate.getNumIdle();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public synchronized String getUrl() {
        return this.delegate.getUrl();
    }

    public synchronized void setUrl(String url) {
        this.delegate.setUrl(url);
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    public String getValidationQuery() {
        return this.delegate.getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        this.delegate.setValidationQuery(validationQuery);
    }

    public int getValidationQueryTimeout() {
        return this.delegate.getValidationQueryTimeout();
    }

    public void setValidationQueryTimeout(int timeout) {
        this.delegate.setValidationQueryTimeout(timeout);
    }

    public List<String> getConnectionInitSqls() {
        return this.delegate.getConnectionInitSqls();
    }

    public void setConnectionInitSqls(Collection<String> connectionInitSqls) {
        this.delegate.setConnectionInitSqls(connectionInitSqls);
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.delegate.isAccessToUnderlyingConnectionAllowed();
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.delegate.setAccessToUnderlyingConnectionAllowed(allow);
    }

    public Connection getConnection() throws SQLException {
        return this.connectionInterceptor.getConnection(this.delegate);
    }

    public Connection getConnection(String login, String password) throws SQLException {
        return this.connectionInterceptor.getConnection(this, login, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.delegate.setLoginTimeout(loginTimeout);
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.delegate.setLogWriter(logWriter);
    }

    public boolean getRemoveAbandonedOnBorrow() {
        return this.delegate.getRemoveAbandonedOnBorrow();
    }

    public void setRemoveAbandonedOnBorrow(boolean removeAbandoned) {
        this.delegate.setRemoveAbandonedOnBorrow(removeAbandoned);
    }

    public boolean getRemoveAbandonedOnMaintenance() {
        return this.delegate.getRemoveAbandonedOnMaintenance();
    }

    public void setRemoveAbandonedOnMaintenance(boolean removeAbandoned) {
        this.delegate.setRemoveAbandonedOnMaintenance(removeAbandoned);
    }

    public int getRemoveAbandonedTimeout() {
        return this.delegate.getRemoveAbandonedTimeout();
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.delegate.setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    public boolean getLogAbandoned() {
        return this.delegate.getLogAbandoned();
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.delegate.setLogAbandoned(logAbandoned);
    }

    public void addConnectionProperty(String name, String value) {
        this.delegate.addConnectionProperty(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.delegate.removeConnectionProperty(name);
    }

    public void setConnectionProperties(String connectionProperties) {
        this.delegate.setConnectionProperties(connectionProperties);
    }

    public synchronized void close() throws SQLException {
        this.delegate.close();
    }

    public synchronized boolean isClosed() {
        return this.delegate.isClosed();
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.delegate.unwrap(iface);
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.delegate.setDefaultAutoCommit(defaultAutoCommit);
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.delegate.setDefaultReadOnly(defaultReadOnly);
    }

    public Integer getDefaultQueryTimeout() {
        return this.delegate.getDefaultQueryTimeout();
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeoutSeconds) {
        this.delegate.setDefaultQueryTimeout(defaultQueryTimeoutSeconds);
    }

    public String getDefaultSchema() {
        return this.delegate.getDefaultSchema();
    }

    public void setDefaultSchema(String defaultSchema) {
        this.delegate.setDefaultSchema(defaultSchema);
    }

    public boolean getCacheState() {
        return this.delegate.getCacheState();
    }

    public void setCacheState(boolean cacheState) {
        this.delegate.setCacheState(cacheState);
    }

    public synchronized Driver getDriver() {
        return this.delegate.getDriver();
    }

    public synchronized void setDriver(Driver driver) {
        this.delegate.setDriver(driver);
    }

    public synchronized boolean getLifo() {
        return this.delegate.getLifo();
    }

    public synchronized void setLifo(boolean lifo) {
        this.delegate.setLifo(lifo);
    }

    public synchronized boolean getTestOnCreate() {
        return this.delegate.getTestOnCreate();
    }

    public synchronized void setTestOnCreate(boolean testOnCreate) {
        this.delegate.setTestOnCreate(testOnCreate);
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.delegate.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
    }

    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.delegate.getSoftMinEvictableIdleTimeMillis();
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.delegate.getEvictionPolicyClassName();
    }

    public synchronized void setEvictionPolicyClassName(String evictionPolicyClassName) {
        this.delegate.setEvictionPolicyClassName(evictionPolicyClassName);
    }

    public String[] getConnectionInitSqlsAsArray() {
        return this.delegate.getConnectionInitSqlsAsArray();
    }

    public long getMaxConnLifetimeMillis() {
        return this.delegate.getMaxConnLifetimeMillis();
    }

    public boolean getLogExpiredConnections() {
        return this.delegate.getLogExpiredConnections();
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.delegate.setMaxConnLifetimeMillis(maxConnLifetimeMillis);
    }

    public void setLogExpiredConnections(boolean logExpiredConnections) {
        this.delegate.setLogExpiredConnections(logExpiredConnections);
    }

    public String getJmxName() {
        return this.delegate.getJmxName();
    }

    public void setJmxName(String jmxName) {
        this.delegate.setJmxName(jmxName);
    }

    public boolean getEnableAutoCommitOnReturn() {
        return this.delegate.getEnableAutoCommitOnReturn();
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.delegate.setEnableAutoCommitOnReturn(enableAutoCommitOnReturn);
    }

    public boolean getRollbackOnReturn() {
        return this.delegate.getRollbackOnReturn();
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.delegate.setRollbackOnReturn(rollbackOnReturn);
    }

    public Set<String> getDisconnectionSqlCodes() {
        return this.delegate.getDisconnectionSqlCodes();
    }

    public String[] getDisconnectionSqlCodesAsArray() {
        return this.delegate.getDisconnectionSqlCodesAsArray();
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        this.delegate.setDisconnectionSqlCodes(disconnectionSqlCodes);
    }

    public boolean getFastFailValidation() {
        return this.delegate.getFastFailValidation();
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this.delegate.setFastFailValidation(fastFailValidation);
    }

    public PrintWriter getAbandonedLogWriter() {
        return this.delegate.getAbandonedLogWriter();
    }

    public void setAbandonedLogWriter(PrintWriter logWriter) {
        this.delegate.setAbandonedLogWriter(logWriter);
    }

    public boolean getAbandonedUsageTracking() {
        return this.delegate.getAbandonedUsageTracking();
    }

    public void setAbandonedUsageTracking(boolean usageTracking) {
        this.delegate.setAbandonedUsageTracking(usageTracking);
    }

    public void invalidateConnection(Connection connection) {
        this.delegate.invalidateConnection(connection);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) {
        return this.delegate.preRegister(server, objectName);
    }

    public void postRegister(Boolean registrationDone) {
        this.delegate.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        this.delegate.preDeregister();
    }

    public void postDeregister() {
        this.delegate.postDeregister();
    }
}

