/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.command;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.application.es.EsInstallation;
import org.sonar.process.ProcessId;
import org.sonar.process.System2;

public abstract class AbstractCommand<T extends AbstractCommand> {
    private final ProcessId id;
    private final Map<String, String> envVariables;
    private final Set<String> suppressedEnvVariables = new HashSet<String>();
    private final File workDir;
    private EsInstallation esInstallation;

    protected AbstractCommand(ProcessId id, File workDir, System2 system2) {
        this.id = Objects.requireNonNull(id, "ProcessId can't be null");
        this.workDir = Objects.requireNonNull(workDir, "workDir can't be null");
        this.envVariables = new HashMap<String, String>(system2.getenv());
    }

    public ProcessId getProcessId() {
        return this.id;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    private T castThis() {
        return (T)this;
    }

    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    public Set<String> getSuppressedEnvVariables() {
        return this.suppressedEnvVariables;
    }

    public T suppressEnvVariable(String key) {
        Objects.requireNonNull(key, "key can't be null");
        this.suppressedEnvVariables.add(key);
        this.envVariables.remove(key);
        return this.castThis();
    }

    public T setEnvVariable(String key, String value) {
        this.envVariables.put(Objects.requireNonNull(key, "key can't be null"), Objects.requireNonNull(value, "value can't be null"));
        return this.castThis();
    }

    public T setEsInstallation(EsInstallation esInstallation) {
        this.esInstallation = esInstallation;
        return this.castThis();
    }

    @CheckForNull
    public EsInstallation getEsInstallation() {
        return this.esInstallation;
    }
}

