/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.io.File;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class FileSystemSettings
implements Consumer<Props> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemSettings.class);

    @Override
    public void accept(Props props) {
        FileSystemSettings.ensurePropertyIsAbsolutePath(props, ProcessProperties.Property.PATH_DATA.getKey());
        FileSystemSettings.ensurePropertyIsAbsolutePath(props, ProcessProperties.Property.PATH_WEB.getKey());
        FileSystemSettings.ensurePropertyIsAbsolutePath(props, ProcessProperties.Property.PATH_LOGS.getKey());
        FileSystemSettings.ensurePropertyIsAbsolutePath(props, ProcessProperties.Property.PATH_TEMP.getKey());
    }

    private static File ensurePropertyIsAbsolutePath(Props props, String propKey) {
        String path = props.nonNullValue(propKey);
        File d = new File(path);
        if (!d.isAbsolute()) {
            File homeDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
            d = new File(homeDir, path);
            LOG.trace("Overriding property {} from relative path '{}' to absolute path '{}'", new Object[]{propKey, path, d.getAbsolutePath()});
            props.set(propKey, d.getAbsolutePath());
        }
        return d;
    }
}

