/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.io.File;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.MessageException;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class JdbcSettings
implements Consumer<Props> {
    private static final int JDBC_EMBEDDED_PORT_DEFAULT_VALUE = 9092;

    @Override
    public void accept(Props props) {
        File homeDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
        Provider provider = this.resolveProviderAndEnforceNonnullJdbcUrl(props);
        String url = props.value(ProcessProperties.Property.JDBC_URL.getKey());
        this.checkUrlParameters(provider, url);
        String driverPath = this.driverPath(homeDir, provider);
        props.set(ProcessProperties.Property.JDBC_DRIVER_PATH.getKey(), driverPath);
    }

    String driverPath(File homeDir, Provider provider) {
        String dirPath = provider.path;
        File dir = new File(homeDir, dirPath);
        if (!dir.exists()) {
            throw new MessageException("Directory does not exist: " + dirPath);
        }
        ArrayList files = new ArrayList(FileUtils.listFiles((File)dir, (String[])new String[]{"jar"}, (boolean)false));
        if (files.isEmpty()) {
            throw new MessageException("Directory does not contain JDBC driver: " + dirPath);
        }
        if (files.size() > 1) {
            throw new MessageException("Directory must contain only one JAR file: " + dirPath);
        }
        return ((File)files.get(0)).getAbsolutePath();
    }

    Provider resolveProviderAndEnforceNonnullJdbcUrl(Props props) {
        String url = props.value(ProcessProperties.Property.JDBC_URL.getKey());
        Integer embeddedDatabasePort = props.valueAsInt(ProcessProperties.Property.JDBC_EMBEDDED_PORT.getKey());
        if (embeddedDatabasePort != null) {
            String correctUrl = JdbcSettings.buildH2JdbcUrl(embeddedDatabasePort);
            JdbcSettings.warnIfUrlIsSet(embeddedDatabasePort, url, correctUrl);
            props.set(ProcessProperties.Property.JDBC_URL.getKey(), correctUrl);
            return Provider.H2;
        }
        if (StringUtils.isEmpty((String)url)) {
            props.set(ProcessProperties.Property.JDBC_URL.getKey(), JdbcSettings.buildH2JdbcUrl(9092));
            props.set(ProcessProperties.Property.JDBC_EMBEDDED_PORT.getKey(), String.valueOf(9092));
            return Provider.H2;
        }
        Pattern pattern = Pattern.compile("jdbc:(\\w+):.+");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new MessageException(String.format("Bad format of JDBC URL: %s", url));
        }
        String key = matcher.group(1);
        try {
            return Provider.valueOf(StringUtils.upperCase((String)key));
        }
        catch (IllegalArgumentException e) {
            throw new MessageException(String.format("Unsupported JDBC driver provider: %s", key));
        }
    }

    private static String buildH2JdbcUrl(int embeddedDatabasePort) {
        InetAddress ip = InetAddress.getLoopbackAddress();
        String host = ip instanceof Inet6Address ? "[" + ip.getHostAddress() + "]" : ip.getHostAddress();
        return String.format("jdbc:h2:tcp://%s:%d/sonar", host, embeddedDatabasePort);
    }

    void checkUrlParameters(Provider provider, String url) {
        if (Provider.MYSQL.equals((Object)provider)) {
            JdbcSettings.checkRequiredParameter(url, "useUnicode=true");
            JdbcSettings.checkRequiredParameter(url, "characterEncoding=utf8");
            this.checkRecommendedParameter(url, "rewriteBatchedStatements=true");
            this.checkRecommendedParameter(url, "useConfigs=maxPerformance");
        }
    }

    private static void warnIfUrlIsSet(int port, String existing, String expectedUrl) {
        if (StringUtils.isNotEmpty((String)existing)) {
            Logger logger = LoggerFactory.getLogger(JdbcSettings.class);
            if (expectedUrl.equals(existing)) {
                logger.warn("To change H2 database port, only property '" + ProcessProperties.Property.JDBC_EMBEDDED_PORT + "' should be set (which current value is '{}'). Remove property '" + ProcessProperties.Property.JDBC_URL + "' from configuration to remove this warning.", (Object)port);
            } else {
                logger.warn("Both '" + ProcessProperties.Property.JDBC_EMBEDDED_PORT + "' and '" + ProcessProperties.Property.JDBC_URL + "' properties are set. The value of property '" + ProcessProperties.Property.JDBC_URL + "' ('{}') is not consistent with the value of property '" + ProcessProperties.Property.JDBC_EMBEDDED_PORT + "' ('{}'). The value of property '" + ProcessProperties.Property.JDBC_URL + "' will be ignored and value '{}' will be used instead. To remove this warning, either remove property '" + ProcessProperties.Property.JDBC_URL + "' if your intent was to use the embedded H2 database, otherwise remove property '" + ProcessProperties.Property.JDBC_EMBEDDED_PORT + "'.", new Object[]{existing, port, expectedUrl});
            }
        }
    }

    private static void checkRequiredParameter(String url, String val) {
        if (!url.contains(val)) {
            throw new MessageException(String.format("JDBC URL must have the property '%s'", val));
        }
    }

    private void checkRecommendedParameter(String url, String val) {
        if (!url.contains(val)) {
            LoggerFactory.getLogger(this.getClass()).warn("JDBC URL is recommended to have the property '{}'", (Object)val);
        }
    }

    static enum Provider {
        H2("lib/jdbc/h2"),
        SQLSERVER("lib/jdbc/mssql"),
        MYSQL("lib/jdbc/mysql"),
        ORACLE("extensions/jdbc-driver/oracle"),
        POSTGRESQL("lib/jdbc/postgresql");

        final String path;

        private Provider(String path) {
            this.path = path;
        }
    }
}

