/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.es;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.es.EsInstallation;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.System2;

public class EsSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsSettings.class);
    private static final String STANDALONE_NODE_NAME = "sonarqube";
    private static final String SECCOMP_PROPERTY = "bootstrap.system_call_filter";
    private final Props props;
    private final EsInstallation fileSystem;
    private final boolean clusterEnabled;
    private final String clusterName;
    private final String nodeName;

    public EsSettings(Props props, EsInstallation fileSystem, System2 system2) {
        this.props = props;
        this.fileSystem = fileSystem;
        this.clusterName = props.nonNullValue(ProcessProperties.Property.CLUSTER_NAME.getKey());
        this.clusterEnabled = props.valueAsBoolean(ProcessProperties.Property.CLUSTER_ENABLED.getKey());
        this.nodeName = this.clusterEnabled ? props.value(ProcessProperties.Property.CLUSTER_NODE_NAME.getKey(), "sonarqube-" + UUID.randomUUID().toString()) : STANDALONE_NODE_NAME;
        String esJvmOptions = system2.getenv("ES_JVM_OPTIONS");
        if (esJvmOptions != null && !esJvmOptions.trim().isEmpty()) {
            LOGGER.warn("ES_JVM_OPTIONS is defined but will be ignored. Use sonar.search.javaOpts and/or sonar.search.javaAdditionalOpts in sonar.properties to specify jvm options for Elasticsearch");
        }
    }

    public Map<String, String> build() {
        HashMap<String, String> builder = new HashMap<String, String>();
        this.configureFileSystem(builder);
        this.configureNetwork(builder);
        this.configureCluster(builder);
        this.configureOthers(builder);
        return builder;
    }

    private void configureFileSystem(Map<String, String> builder) {
        builder.put("path.data", this.fileSystem.getDataDirectory().getAbsolutePath());
        builder.put("path.logs", this.fileSystem.getLogDirectory().getAbsolutePath());
    }

    private void configureNetwork(Map<String, String> builder) {
        InetAddress host = this.readHost();
        int port = Integer.parseInt(this.props.nonNullValue(ProcessProperties.Property.SEARCH_PORT.getKey()));
        LOGGER.info("Elasticsearch listening on {}:{}", (Object)host, (Object)port);
        builder.put("transport.tcp.port", String.valueOf(port));
        builder.put("transport.host", String.valueOf(host.getHostAddress()));
        builder.put("network.host", String.valueOf(host.getHostAddress()));
        builder.put("network.tcp.reuse_address", String.valueOf(true));
        int httpPort = this.props.valueAsInt(ProcessProperties.Property.SEARCH_HTTP_PORT.getKey(), -1);
        if (httpPort < 0) {
            builder.put("http.enabled", String.valueOf(false));
        } else {
            LOGGER.warn("Elasticsearch HTTP connector is enabled on port {}. MUST NOT BE USED FOR PRODUCTION", (Object)httpPort);
            builder.put("http.cors.enabled", String.valueOf(true));
            builder.put("http.cors.allow-origin", "*");
            builder.put("http.enabled", String.valueOf(true));
            builder.put("http.host", host.getHostAddress());
            builder.put("http.port", String.valueOf(httpPort));
        }
    }

    private InetAddress readHost() {
        String hostProperty = this.props.nonNullValue(ProcessProperties.Property.SEARCH_HOST.getKey());
        try {
            return InetAddress.getByName(hostProperty);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Can not resolve host [" + hostProperty + "]. Please check network settings and property " + ProcessProperties.Property.SEARCH_HOST.getKey(), e);
        }
    }

    private void configureCluster(Map<String, String> builder) {
        int minimumMasterNodes = 1;
        String initialStateTimeOut = "30s";
        if (this.clusterEnabled) {
            minimumMasterNodes = this.props.valueAsInt(ProcessProperties.Property.SEARCH_MINIMUM_MASTER_NODES.getKey(), 2);
            initialStateTimeOut = this.props.value(ProcessProperties.Property.SEARCH_INITIAL_STATE_TIMEOUT.getKey(), "120s");
            String hosts = this.props.value(ProcessProperties.Property.CLUSTER_SEARCH_HOSTS.getKey(), "");
            LOGGER.info("Elasticsearch cluster enabled. Connect to hosts [{}]", (Object)hosts);
            builder.put("discovery.zen.ping.unicast.hosts", hosts);
        }
        builder.put("discovery.zen.minimum_master_nodes", String.valueOf(minimumMasterNodes));
        builder.put("discovery.initial_state_timeout", initialStateTimeOut);
        builder.put("cluster.name", this.clusterName);
        builder.put("cluster.routing.allocation.awareness.attributes", "rack_id");
        builder.put("node.attr.rack_id", this.nodeName);
        builder.put("node.name", this.nodeName);
        builder.put("node.data", String.valueOf(true));
        builder.put("node.master", String.valueOf(true));
    }

    private void configureOthers(Map<String, String> builder) {
        builder.put("action.auto_create_index", String.valueOf(false));
        if (this.props.value("sonar.search.javaAdditionalOpts", "").contains("-Dbootstrap.system_call_filter=false")) {
            builder.put(SECCOMP_PROPERTY, "false");
        }
    }
}

