/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.es.EsConnector;
import org.sonar.application.process.AbstractProcessMonitor;
import org.sonar.process.ProcessId;

public class EsProcessMonitor
extends AbstractProcessMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(EsProcessMonitor.class);
    private static final int WAIT_FOR_UP_DELAY_IN_MILLIS = 100;
    private static final int WAIT_FOR_UP_TIMEOUT = 600;
    private final AtomicBoolean nodeUp = new AtomicBoolean(false);
    private final AtomicBoolean nodeOperational = new AtomicBoolean(false);
    private final AtomicBoolean firstMasterNotDiscoveredLog = new AtomicBoolean(true);
    private final EsConnector esConnector;

    public EsProcessMonitor(Process process, ProcessId processId, EsConnector esConnector) {
        super(process, processId);
        this.esConnector = esConnector;
    }

    @Override
    public boolean isOperational() {
        if (this.nodeOperational.get()) {
            return true;
        }
        boolean flag = false;
        try {
            flag = this.checkOperational();
        }
        catch (InterruptedException e) {
            LOG.trace("Interrupted while checking ES node is operational", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (flag) {
                this.esConnector.stop();
                this.nodeOperational.set(true);
            }
        }
        return this.nodeOperational.get();
    }

    private boolean checkOperational() throws InterruptedException {
        int i = 0;
        Status status = this.checkStatus();
        do {
            if (status != Status.CONNECTION_REFUSED) {
                this.nodeUp.set(true);
                continue;
            }
            Thread.sleep(100L);
            ++i;
            status = this.checkStatus();
        } while (!this.nodeUp.get() && i < 600);
        return status == Status.YELLOW || status == Status.GREEN;
    }

    private Status checkStatus() {
        try {
            switch (this.esConnector.getClusterHealthStatus()) {
                case GREEN: {
                    return Status.GREEN;
                }
                case YELLOW: {
                    return Status.YELLOW;
                }
                case RED: {
                    return Status.RED;
                }
            }
            return Status.KO;
        }
        catch (NoNodeAvailableException e) {
            return Status.CONNECTION_REFUSED;
        }
        catch (MasterNotDiscoveredException e) {
            if (this.firstMasterNotDiscoveredLog.getAndSet(false)) {
                LOG.info("Elasticsearch is waiting for a master to be elected. Did you start all the search nodes ?");
            }
            return Status.KO;
        }
        catch (Exception e) {
            LOG.error("Failed to check status", (Throwable)e);
            return Status.KO;
        }
    }

    @Override
    public void askForStop() {
        this.process.destroy();
    }

    @Override
    public boolean askedForRestart() {
        return false;
    }

    @Override
    public void acknowledgeAskForRestart() {
    }

    static enum Status {
        CONNECTION_REFUSED,
        KO,
        RED,
        YELLOW,
        GREEN;

    }
}

