/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.process.ProcessLifecycleListener;
import org.sonar.process.ProcessId;

public class Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(Lifecycle.class);
    private static final Map<State, Set<State>> TRANSITIONS = Lifecycle.buildTransitions();
    private final ProcessId processId;
    private final List<ProcessLifecycleListener> listeners;
    private State state;

    public Lifecycle(ProcessId processId, List<ProcessLifecycleListener> listeners) {
        this(processId, listeners, State.INIT);
    }

    Lifecycle(ProcessId processId, List<ProcessLifecycleListener> listeners, State initialState) {
        this.processId = processId;
        this.listeners = listeners;
        this.state = initialState;
    }

    private static Map<State, Set<State>> buildTransitions() {
        EnumMap<State, Set<State>> res = new EnumMap<State, Set<State>>(State.class);
        res.put(State.INIT, Lifecycle.toSet(State.STARTING));
        res.put(State.STARTING, Lifecycle.toSet(State.STARTED, State.STOPPING, State.STOPPED));
        res.put(State.STARTED, Lifecycle.toSet(State.STOPPING, State.STOPPED));
        res.put(State.STOPPING, Lifecycle.toSet(State.STOPPED));
        res.put(State.STOPPED, Lifecycle.toSet(new State[0]));
        return res;
    }

    private static Set<State> toSet(State ... states) {
        if (states.length == 0) {
            return Collections.emptySet();
        }
        if (states.length == 1) {
            return Collections.singleton(states[0]);
        }
        return EnumSet.copyOf(Arrays.asList(states));
    }

    State getState() {
        return this.state;
    }

    synchronized boolean tryToMoveTo(State to) {
        boolean res = false;
        State currentState = this.state;
        if (TRANSITIONS.get((Object)currentState).contains((Object)to)) {
            this.state = to;
            res = true;
            this.listeners.forEach(listener -> listener.onProcessState(this.processId, to));
        }
        LOG.trace("tryToMoveTo {} from {} to {} => {}", new Object[]{this.processId.getKey(), currentState, to, res});
        return res;
    }

    public static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

