/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.command.AbstractCommand;
import org.sonar.application.command.EsScriptCommand;
import org.sonar.application.command.JavaCommand;
import org.sonar.application.command.JvmOptions;
import org.sonar.application.es.EsConnectorImpl;
import org.sonar.application.es.EsInstallation;
import org.sonar.application.process.EsProcessMonitor;
import org.sonar.application.process.ProcessCommandsProcessMonitor;
import org.sonar.application.process.ProcessLauncher;
import org.sonar.application.process.ProcessMonitor;
import org.sonar.process.FileUtils2;
import org.sonar.process.ProcessId;
import org.sonar.process.sharedmemoryfile.AllProcessesCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class ProcessLauncherImpl
implements ProcessLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessLauncherImpl.class);
    private final File tempDir;
    private final AllProcessesCommands allProcessesCommands;
    private final Supplier<ProcessBuilder> processBuilderSupplier;

    public ProcessLauncherImpl(File tempDir) {
        this(tempDir, new AllProcessesCommands(tempDir), () -> new JavaLangProcessBuilder());
    }

    ProcessLauncherImpl(File tempDir, AllProcessesCommands allProcessesCommands, Supplier<ProcessBuilder> processBuilderSupplier) {
        this.tempDir = tempDir;
        this.allProcessesCommands = allProcessesCommands;
        this.processBuilderSupplier = processBuilderSupplier;
    }

    @Override
    public void close() {
        this.allProcessesCommands.close();
    }

    @Override
    public ProcessMonitor launch(AbstractCommand command) {
        Process process;
        EsInstallation esInstallation = command.getEsInstallation();
        if (esInstallation != null) {
            ProcessLauncherImpl.cleanupOutdatedEsData(esInstallation);
            ProcessLauncherImpl.writeConfFiles(esInstallation);
            ProcessLauncherImpl.ensureTempDirExists(esInstallation);
        }
        if (command instanceof EsScriptCommand) {
            process = this.launchExternal((EsScriptCommand)command);
        } else if (command instanceof JavaCommand) {
            process = this.launchJava((JavaCommand)command);
        } else {
            throw new IllegalStateException("Unexpected type of command: " + command.getClass());
        }
        ProcessId processId = command.getProcessId();
        try {
            if (processId == ProcessId.ELASTICSEARCH) {
                Preconditions.checkArgument((esInstallation != null ? 1 : 0) != 0, (Object)"Incorrect configuration EsInstallation is null");
                EsConnectorImpl esConnector = new EsConnectorImpl(esInstallation.getClusterName(), Collections.singleton(HostAndPort.fromParts((String)esInstallation.getHost(), (int)esInstallation.getPort())));
                return new EsProcessMonitor(process, processId, esConnector);
            }
            ProcessCommands commands = this.allProcessesCommands.createAfterClean(processId.getIpcIndex());
            return new ProcessCommandsProcessMonitor(process, processId, commands);
        }
        catch (Exception e) {
            if (process != null) {
                process.destroyForcibly();
            }
            throw new IllegalStateException(String.format("Fail to launch monitor of process [%s]", processId.getKey()), e);
        }
    }

    private Process launchExternal(EsScriptCommand esScriptCommand) {
        try {
            ProcessBuilder processBuilder = this.create(esScriptCommand);
            ProcessLauncherImpl.logLaunchedCommand(esScriptCommand, processBuilder);
            return processBuilder.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to launch process [%s]", esScriptCommand.getProcessId().getKey()), e);
        }
    }

    private static void cleanupOutdatedEsData(EsInstallation esInstallation) {
        esInstallation.getOutdatedSearchDirectories().forEach(outdatedDir -> {
            if (outdatedDir.exists()) {
                LOG.info("Deleting outdated search index data directory {}", (Object)outdatedDir.getAbsolutePath());
                try {
                    FileUtils2.deleteDirectory((File)outdatedDir);
                }
                catch (IOException e) {
                    LOG.info("Failed to delete outdated search index data directory {}", (Object)outdatedDir.getAbsolutePath(), (Object)e);
                }
            }
        });
    }

    private static void writeConfFiles(EsInstallation esInstallation) {
        File confDir = esInstallation.getConfDirectory();
        if (!confDir.exists() && !confDir.mkdirs()) {
            String error = String.format("Failed to create temporary configuration directory [%s]", confDir.getAbsolutePath());
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        try {
            esInstallation.getEsYmlSettings().writeToYmlSettingsFile(esInstallation.getElasticsearchYml());
            esInstallation.getEsJvmOptions().writeToJvmOptionFile(esInstallation.getJvmOptions());
            esInstallation.getLog4j2Properties().store(new FileOutputStream(esInstallation.getLog4j2PropertiesLocation()), "log4j2 properties file for ES bundled in SonarQube");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write ES configuration files", e);
        }
    }

    private static void ensureTempDirExists(EsInstallation esInstallation) {
        File tmpDirectory = esInstallation.getTmpDirectory();
        if (!tmpDirectory.exists() && !tmpDirectory.mkdirs()) {
            String error = String.format("Failed to create ES temporary directory [%s]", tmpDirectory.getAbsolutePath());
            LOG.error(error);
            throw new IllegalStateException(error);
        }
    }

    private <T extends JvmOptions> Process launchJava(JavaCommand<T> javaCommand) {
        ProcessId processId = javaCommand.getProcessId();
        try {
            ProcessBuilder processBuilder = this.create(javaCommand);
            ProcessLauncherImpl.logLaunchedCommand(javaCommand, processBuilder);
            return processBuilder.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to launch process [%s]", processId.getKey()), e);
        }
    }

    private static <T extends AbstractCommand> void logLaunchedCommand(AbstractCommand<T> command, ProcessBuilder processBuilder) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Launch process[{}] from [{}]: {}", new Object[]{command.getProcessId(), command.getWorkDir().getAbsolutePath(), String.join((CharSequence)" ", processBuilder.command())});
        }
    }

    private ProcessBuilder create(EsScriptCommand esScriptCommand) {
        ArrayList<String> commands = new ArrayList<String>();
        EsInstallation esInstallation = esScriptCommand.getEsInstallation();
        Objects.requireNonNull(esInstallation, () -> "No Elasticsearch installation configuration is available for the command of type " + esScriptCommand.getClass());
        commands.add(esInstallation.getExecutable().getAbsolutePath());
        commands.addAll(esScriptCommand.getOptions());
        return this.create(esScriptCommand, commands);
    }

    private <T extends JvmOptions> ProcessBuilder create(JavaCommand<T> javaCommand) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(ProcessLauncherImpl.buildJavaPath());
        commands.addAll(javaCommand.getJvmOptions().getAll());
        commands.addAll(ProcessLauncherImpl.buildClasspath(javaCommand));
        commands.add(javaCommand.getClassName());
        if (javaCommand.getReadsArgumentsFromFile()) {
            commands.add(this.buildPropertiesFile(javaCommand).getAbsolutePath());
        } else {
            javaCommand.getArguments().forEach((key, value) -> {
                if (value != null && !value.isEmpty()) {
                    commands.add("-E" + key + "=" + value);
                }
            });
        }
        return this.create(javaCommand, commands);
    }

    private ProcessBuilder create(AbstractCommand<?> command, List<String> commands) {
        ProcessBuilder processBuilder = this.processBuilderSupplier.get();
        processBuilder.command(commands);
        processBuilder.directory(command.getWorkDir());
        Map<String, String> environment = processBuilder.environment();
        environment.putAll(command.getEnvVariables());
        command.getSuppressedEnvVariables().forEach(environment::remove);
        processBuilder.redirectErrorStream(true);
        return processBuilder;
    }

    private static String buildJavaPath() {
        String separator = System.getProperty("file.separator");
        return new File(new File(System.getProperty("java.home")), "bin" + separator + "java").getAbsolutePath();
    }

    private static <T extends JvmOptions> List<String> buildClasspath(JavaCommand<T> javaCommand) {
        String pathSeparator = System.getProperty("path.separator");
        return Arrays.asList("-cp", String.join((CharSequence)pathSeparator, javaCommand.getClasspath()));
    }

    private File buildPropertiesFile(JavaCommand javaCommand) {
        File propertiesFile = null;
        try {
            propertiesFile = File.createTempFile("sq-process", "properties", this.tempDir);
            Properties props = new Properties();
            props.putAll(javaCommand.getArguments());
            props.setProperty("process.key", javaCommand.getProcessId().getKey());
            props.setProperty("process.index", Integer.toString(javaCommand.getProcessId().getIpcIndex()));
            props.setProperty("process.terminationTimeout", "60000");
            props.setProperty("process.sharedDir", this.tempDir.getAbsolutePath());
            try (FileOutputStream out = new FileOutputStream(propertiesFile);){
                props.store(out, String.format("Temporary properties file for command [%s]", javaCommand.getProcessId().getKey()));
            }
            return propertiesFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot write temporary settings to " + propertiesFile, e);
        }
    }

    private static class JavaLangProcessBuilder
    implements ProcessBuilder {
        private final java.lang.ProcessBuilder builder = new java.lang.ProcessBuilder(new String[0]);

        private JavaLangProcessBuilder() {
        }

        @Override
        public List<String> command() {
            return this.builder.command();
        }

        @Override
        public ProcessBuilder command(List<String> commands) {
            this.builder.command(commands);
            return this;
        }

        @Override
        public ProcessBuilder directory(File dir) {
            this.builder.directory(dir);
            return this;
        }

        @Override
        public Map<String, String> environment() {
            return this.builder.environment();
        }

        @Override
        public ProcessBuilder redirectErrorStream(boolean b) {
            this.builder.redirectErrorStream(b);
            return this;
        }

        @Override
        public Process start() throws IOException {
            return this.builder.start();
        }
    }

    public static interface ProcessBuilder {
        public List<String> command();

        public ProcessBuilder command(List<String> var1);

        public ProcessBuilder directory(File var1);

        public Map<String, String> environment();

        public ProcessBuilder redirectErrorStream(boolean var1);

        public Process start() throws IOException;
    }
}

