/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.io.File;
import org.sonar.application.FileSystem;
import org.sonar.application.Scheduler;
import org.sonar.application.config.AppSettings;
import org.sonar.application.process.StopRequestWatcher;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class StopRequestWatcherImpl
extends Thread
implements StopRequestWatcher {
    private static final long DEFAULT_WATCHER_DELAY_MS = 500L;
    private final ProcessCommands commands;
    private final Scheduler scheduler;
    private final AppSettings settings;
    private long delayMs = 500L;

    StopRequestWatcherImpl(AppSettings settings, Scheduler scheduler, ProcessCommands commands) {
        super("StopRequestWatcherImpl");
        this.settings = settings;
        this.commands = commands;
        this.scheduler = scheduler;
        this.setDaemon(true);
    }

    public static StopRequestWatcherImpl create(AppSettings settings, Scheduler scheduler, FileSystem fs) {
        DefaultProcessCommands commands = DefaultProcessCommands.secondary((File)fs.getTempDir(), (int)ProcessId.APP.getIpcIndex());
        return new StopRequestWatcherImpl(settings, scheduler, (ProcessCommands)commands);
    }

    long getDelayMs() {
        return this.delayMs;
    }

    void setDelayMs(long delayMs) {
        this.delayMs = delayMs;
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.commands.askedForStop()) {
                    this.scheduler.terminate();
                    return;
                }
                Thread.sleep(this.delayMs);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public void startWatching() {
        if (this.settings.getProps().valueAsBoolean(ProcessProperties.Property.ENABLE_STOP_COMMAND.getKey())) {
            this.start();
        }
    }

    @Override
    public void stopWatching() {
        this.interrupt();
    }
}

