/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.sonar.core.util.CloseableIterator;

final class LogsIteratorInputStream
extends InputStream {
    private static final int UNSET = -1;
    private static final int END_OF_STREAM = -1;
    private final Charset charset;
    private final byte[] lineFeed;
    private CloseableIterator<String> logsIterator;
    private byte[] buf;
    private int nextChar = -1;

    LogsIteratorInputStream(CloseableIterator<String> logsIterator, Charset charset) {
        Preconditions.checkArgument((boolean)logsIterator.hasNext(), (Object)"LogsIterator can't be empty or already read");
        this.charset = charset;
        this.lineFeed = "\n".getBytes(charset);
        this.logsIterator = logsIterator;
    }

    @Override
    public int read() {
        if (this.nextChar == -1 || this.nextChar >= this.buf.length) {
            this.fill();
            if (this.nextChar == -1) {
                return -1;
            }
        }
        return this.buf[this.nextChar++];
    }

    private void fill() {
        if (this.logsIterator.hasNext()) {
            int bufLength;
            byte[] line = ((String)this.logsIterator.next()).getBytes(this.charset);
            boolean hasNextLine = this.logsIterator.hasNext();
            int n = bufLength = hasNextLine ? line.length + this.lineFeed.length : line.length;
            if (bufLength == 0) {
                this.buf = null;
                this.nextChar = -1;
            } else {
                this.buf = new byte[bufLength];
                System.arraycopy(line, 0, this.buf, 0, line.length);
                if (hasNextLine) {
                    System.arraycopy(this.lineFeed, 0, this.buf, line.length, this.lineFeed.length);
                }
                this.nextChar = 0;
            }
        } else {
            this.buf = null;
            this.nextChar = -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.logsIterator.close();
        this.buf = null;
        super.close();
    }
}

