/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.event;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class EventValidator {
    public static final int MAX_NAME_LENGTH = 400;
    private static final int MAX_CATEGORY_LENGTH = 50;
    private static final int MAX_DESCRIPTION_LENGTH = 4000;

    private EventValidator() {
    }

    @CheckForNull
    static String checkEventName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Preconditions.checkArgument((name.length() <= 400 ? 1 : 0) != 0, (String)"Event name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{name.length(), 400, name});
        return name;
    }

    @CheckForNull
    static String checkEventCategory(@Nullable String category) {
        if (category == null) {
            return null;
        }
        Preconditions.checkArgument((category.length() <= 50 ? 1 : 0) != 0, (String)"Event category length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{category.length(), 50, category});
        return category;
    }

    @CheckForNull
    static String checkEventDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        Preconditions.checkArgument((description.length() <= 4000 ? 1 : 0) != 0, (String)"Event description length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{description.length(), 4000, description});
        return description;
    }
}

