/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.utils.System2;
import org.sonar.core.util.Uuids;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.KeyType;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.LiveMeasureMapper;
import org.sonar.db.measure.MeasureTreeQuery;
import org.sonar.db.measure.SumNclocDbQuery;

public class LiveMeasureDao
implements Dao {
    private final System2 system2;

    public LiveMeasureDao(System2 system2) {
        this.system2 = system2;
    }

    public List<LiveMeasureDto> selectByComponentUuidsAndMetricIds(DbSession dbSession, Collection<String> largeComponentUuids, Collection<Integer> metricIds) {
        if (largeComponentUuids.isEmpty() || metricIds.isEmpty()) {
            return Collections.emptyList();
        }
        return DatabaseUtils.executeLargeInputs(largeComponentUuids, componentUuids -> LiveMeasureDao.mapper(dbSession).selectByComponentUuidsAndMetricIds((Collection<String>)componentUuids, metricIds));
    }

    public List<LiveMeasureDto> selectByComponentUuidsAndMetricKeys(DbSession dbSession, Collection<String> largeComponentUuids, Collection<String> metricKeys) {
        if (largeComponentUuids.isEmpty() || metricKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return DatabaseUtils.executeLargeInputs(largeComponentUuids, componentUuids -> LiveMeasureDao.mapper(dbSession).selectByComponentUuidsAndMetricKeys((Collection<String>)componentUuids, metricKeys));
    }

    public Optional<LiveMeasureDto> selectByComponentUuidAndMetricKey(DbSession dbSession, String componentUuid, String metricKey) {
        LiveMeasureDto liveMeasureDto = LiveMeasureDao.mapper(dbSession).selectByComponentUuidAndMetricKey(componentUuid, metricKey);
        return Optional.ofNullable(liveMeasureDto);
    }

    public Optional<LiveMeasureDto> selectMeasure(DbSession dbSession, String componentUuid, String metricKey) {
        List<LiveMeasureDto> measures = this.selectByComponentUuidsAndMetricKeys(dbSession, Collections.singletonList(componentUuid), Collections.singletonList(metricKey));
        if (measures.size() == 1) {
            return Optional.of(measures.get(0));
        }
        return Optional.empty();
    }

    public void selectTreeByQuery(DbSession dbSession, ComponentDto baseComponent, MeasureTreeQuery query, ResultHandler<LiveMeasureDto> resultHandler) {
        if (query.returnsEmpty()) {
            return;
        }
        LiveMeasureDao.mapper(dbSession).selectTreeByQuery(query, baseComponent.uuid(), query.getUuidPath(baseComponent), resultHandler);
    }

    public long sumNclocOfBiggestLongLivingBranch(DbSession dbSession, SumNclocDbQuery dbQuery) {
        Long ncloc = LiveMeasureDao.mapper(dbSession).sumNclocOfBiggestLongLivingBranch("ncloc", KeyType.BRANCH, BranchType.LONG, dbQuery.getOrganizationUuid(), dbQuery.getOnlyPrivateProjects(), dbQuery.getProjectUuidToExclude());
        return ncloc == null ? 0L : ncloc;
    }

    public void insert(DbSession dbSession, LiveMeasureDto dto) {
        LiveMeasureDao.mapper(dbSession).insert(dto, Uuids.create(), this.system2.now());
    }

    public void insertOrUpdate(DbSession dbSession, LiveMeasureDto dto) {
        long now;
        LiveMeasureMapper mapper = LiveMeasureDao.mapper(dbSession);
        if (mapper.update(dto, now = this.system2.now()) == 0) {
            mapper.insert(dto, Uuids.create(), now);
        }
    }

    public int upsert(DbSession dbSession, Iterable<LiveMeasureDto> dtos) {
        for (LiveMeasureDto dto : dtos) {
            dto.setUuidForUpsert(Uuids.create());
        }
        int updated = 0;
        for (List chunk : Iterables.partition(dtos, (int)100)) {
            updated += LiveMeasureDao.mapper(dbSession).upsert(chunk, this.system2.now());
        }
        return updated;
    }

    public int deleteByComponentUuidExcludingMetricIds(DbSession dbSession, String componentUuid, List<Integer> excludedMetricIds) {
        return LiveMeasureDao.mapper(dbSession).deleteByComponentUuidExcludingMetricIds(componentUuid, excludedMetricIds);
    }

    private static LiveMeasureMapper mapper(DbSession dbSession) {
        return (LiveMeasureMapper)dbSession.getMapper(LiveMeasureMapper.class);
    }
}

