/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.metric;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class MetricValidator {
    public static final int MAX_KEY_LENGTH = 64;
    public static final int MAX_NAME_LENGTH = 64;
    public static final int MAX_DOMAIN_LENGTH = 64;
    public static final int MAX_DESCRIPTION_LENGTH = 255;

    private MetricValidator() {
    }

    public static String checkMetricKey(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Metric key cannot be empty");
        Preconditions.checkArgument((key.length() <= 64 ? 1 : 0) != 0, (String)"Metric key length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{key.length(), 64, key});
        return key;
    }

    public static String checkMetricName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Metric name cannot be empty");
        Preconditions.checkArgument((name.length() <= 64 ? 1 : 0) != 0, (String)"Metric name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{name.length(), 64, name});
        return name;
    }

    @CheckForNull
    public static String checkMetricDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        Preconditions.checkArgument((description.length() <= 255 ? 1 : 0) != 0, (String)"Metric description length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{description.length(), 255, description});
        return description;
    }

    @CheckForNull
    public static String checkMetricDomain(@Nullable String domain) {
        if (domain == null) {
            return null;
        }
        Preconditions.checkArgument((domain.length() <= 64 ? 1 : 0) != 0, (String)"Metric domain length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{domain.length(), 64, domain});
        return domain;
    }
}

