/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.alm.ALM;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.KeyType;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationMapper;
import org.sonar.db.organization.OrganizationQuery;
import org.sonar.db.organization.OrganizationWithNclocDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.user.GroupDto;

public class OrganizationDao
implements Dao {
    private final System2 system2;

    public OrganizationDao(System2 system2) {
        this.system2 = system2;
    }

    public void insert(DbSession dbSession, OrganizationDto organization, boolean newProjectPrivate) {
        OrganizationDao.checkDto(organization);
        long now = this.system2.now();
        organization.setCreatedAt(now);
        organization.setUpdatedAt(now);
        OrganizationDao.getMapper(dbSession).insert(organization, newProjectPrivate);
    }

    public int countByQuery(DbSession dbSession, OrganizationQuery organizationQuery) {
        Objects.requireNonNull(organizationQuery, "organizationQuery can't be null");
        return OrganizationDao.getMapper(dbSession).countByQuery(organizationQuery);
    }

    public List<OrganizationDto> selectByQuery(DbSession dbSession, OrganizationQuery organizationQuery, Pagination pagination) {
        Objects.requireNonNull(organizationQuery, "organizationQuery can't be null");
        return OrganizationDao.getMapper(dbSession).selectByQuery(organizationQuery, pagination);
    }

    public Optional<OrganizationDto> selectByUuid(DbSession dbSession, String uuid) {
        OrganizationDao.checkUuid(uuid);
        return Optional.ofNullable(OrganizationDao.getMapper(dbSession).selectByUuid(uuid));
    }

    public Optional<OrganizationDto> selectByKey(DbSession dbSession, String key) {
        Objects.requireNonNull(key, "key can't be null");
        return Optional.ofNullable(OrganizationDao.getMapper(dbSession).selectByKey(key));
    }

    public List<OrganizationDto> selectByUuids(DbSession dbSession, Set<String> organizationUuids) {
        return DatabaseUtils.executeLargeInputs(organizationUuids, OrganizationDao.getMapper(dbSession)::selectByUuids);
    }

    public List<OrganizationDto> selectByPermission(DbSession dbSession, Integer userId, String permission) {
        return OrganizationDao.getMapper(dbSession).selectByPermission(userId, permission);
    }

    public Optional<OrganizationDto> selectByOrganizationAlmId(DbSession dbSession, ALM alm, String organizationAlmId) {
        return Optional.ofNullable(OrganizationDao.getMapper(dbSession).selectByOrganizationAlmId(alm.getId(), organizationAlmId));
    }

    public List<String> selectAllUuids(DbSession dbSession) {
        return OrganizationDao.getMapper(dbSession).selectAllUuids();
    }

    public Optional<DefaultTemplates> getDefaultTemplates(DbSession dbSession, String organizationUuid) {
        OrganizationDao.checkUuid(organizationUuid);
        return Optional.ofNullable(OrganizationDao.getMapper(dbSession).selectDefaultTemplatesByUuid(organizationUuid));
    }

    public void setDefaultTemplates(DbSession dbSession, String uuid, DefaultTemplates defaultTemplates) {
        OrganizationDao.checkUuid(uuid);
        OrganizationDao.checkDefaultTemplates(defaultTemplates);
        long now = this.system2.now();
        OrganizationDao.getMapper(dbSession).updateDefaultTemplates(uuid, defaultTemplates, now);
    }

    public Optional<Integer> getDefaultGroupId(DbSession dbSession, String organizationUuid) {
        OrganizationDao.checkUuid(organizationUuid);
        return Optional.ofNullable(OrganizationDao.getMapper(dbSession).selectDefaultGroupIdByUuid(organizationUuid));
    }

    public void setDefaultGroupId(DbSession dbSession, String uuid, GroupDto defaultGroup) {
        OrganizationDao.checkUuid(uuid);
        Integer defaultGroupId = Objects.requireNonNull(defaultGroup, "Default group cannot be null").getId();
        OrganizationDao.getMapper(dbSession).updateDefaultGroupId(uuid, Objects.requireNonNull(defaultGroupId, "Default group id cannot be null"), this.system2.now());
    }

    public void setDefaultQualityGate(DbSession dbSession, OrganizationDto organization, QGateWithOrgDto qualityGate) {
        OrganizationDao.getMapper(dbSession).updateDefaultQualityGate(organization.getUuid(), qualityGate.getUuid(), this.system2.now());
    }

    public boolean getNewProjectPrivate(DbSession dbSession, OrganizationDto organization) {
        return OrganizationDao.getMapper(dbSession).selectNewProjectPrivateByUuid(organization.getUuid());
    }

    public void setNewProjectPrivate(DbSession dbSession, OrganizationDto organization, boolean newProjectPrivate) {
        OrganizationDao.getMapper(dbSession).updateNewProjectPrivate(organization.getUuid(), newProjectPrivate, this.system2.now());
    }

    public int update(DbSession dbSession, OrganizationDto organization) {
        OrganizationDao.checkDto(organization);
        organization.setUpdatedAt(this.system2.now());
        return OrganizationDao.getMapper(dbSession).update(organization);
    }

    public int deleteByUuid(DbSession dbSession, String uuid) {
        return OrganizationDao.getMapper(dbSession).deleteByUuid(uuid);
    }

    public List<OrganizationWithNclocDto> selectOrganizationsWithNcloc(DbSession dbSession, List<String> organizationUuids) {
        ArrayList<OrganizationWithNclocDto> result = new ArrayList<OrganizationWithNclocDto>();
        DatabaseUtils.executeLargeUpdates(organizationUuids, chunk -> result.addAll(OrganizationDao.getMapper(dbSession).selectOrganizationsWithNcloc("ncloc", (List<String>)chunk, KeyType.BRANCH, BranchType.LONG)));
        return result;
    }

    private static void checkDto(OrganizationDto organization) {
        Objects.requireNonNull(organization, "OrganizationDto can't be null");
    }

    private static OrganizationMapper getMapper(DbSession dbSession) {
        return (OrganizationMapper)dbSession.getMapper(OrganizationMapper.class);
    }

    private static void checkUuid(String uuid) {
        Objects.requireNonNull(uuid, "uuid can't be null");
    }

    private static void checkDefaultTemplates(DefaultTemplates defaultTemplates) {
        Objects.requireNonNull(defaultTemplates, "defaultTemplates can't be null");
        Objects.requireNonNull(defaultTemplates.getProjectUuid());
    }
}

