/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.organization;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;

public class OrganizationQuery {
    private static final OrganizationQuery NO_FILTER = OrganizationQuery.newOrganizationQueryBuilder().build();
    private final Set<String> keys;
    @Nullable
    private final Integer userId;
    private final boolean onlyTeam;
    private final boolean onlyPersonal;
    private final boolean withAnalyses;
    @Nullable
    private final Long analyzedAfter;

    private OrganizationQuery(Builder builder) {
        this.keys = builder.keys;
        this.userId = builder.member;
        this.onlyPersonal = builder.onlyPersonal;
        this.onlyTeam = builder.onlyTeam;
        if (this.onlyPersonal && this.onlyTeam) {
            throw new IllegalArgumentException("Only one of onlyPersonal and onlyTeam can be true");
        }
        this.withAnalyses = builder.withAnalyses;
        this.analyzedAfter = builder.analyzedAfter;
    }

    @CheckForNull
    public Set<String> getKeys() {
        return this.keys;
    }

    @CheckForNull
    public Integer getMember() {
        return this.userId;
    }

    public boolean isOnlyTeam() {
        return this.onlyTeam;
    }

    public boolean isOnlyPersonal() {
        return this.onlyPersonal;
    }

    public boolean isWithAnalyses() {
        return this.withAnalyses;
    }

    @CheckForNull
    public Long getAnalyzedAfter() {
        return this.analyzedAfter;
    }

    public static OrganizationQuery returnAll() {
        return NO_FILTER;
    }

    public static Builder newOrganizationQueryBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> keys;
        @Nullable
        private Integer member;
        private boolean onlyTeam = false;
        private boolean onlyPersonal = false;
        private boolean withAnalyses = false;
        @Nullable
        private Long analyzedAfter;

        private Builder() {
        }

        public Builder setKeys(@Nullable Collection<String> keys) {
            if (keys != null && !keys.isEmpty()) {
                this.keys = (Set)keys.stream().filter(Objects::nonNull).collect(MoreCollectors.toSet((int)keys.size()));
            }
            return this;
        }

        public Builder setMember(@Nullable Integer userId) {
            this.member = userId;
            return this;
        }

        public Builder setOnlyTeam() {
            this.onlyTeam = true;
            return this;
        }

        public Builder setOnlyPersonal() {
            this.onlyPersonal = true;
            return this;
        }

        public Builder setWithAnalyses() {
            this.withAnalyses = true;
            return this;
        }

        public Builder setAnalyzedAfter(long l) {
            this.analyzedAfter = l;
            return this;
        }

        public OrganizationQuery build() {
            return new OrganizationQuery(this);
        }
    }
}

