/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission.template;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.template.CountByTemplateAndPermissionDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicMapper;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.permission.template.PermissionTemplateGroupDto;
import org.sonar.db.permission.template.PermissionTemplateMapper;
import org.sonar.db.permission.template.PermissionTemplateUserDto;

public class PermissionTemplateDao
implements Dao {
    private static final String ANYONE_GROUP_PARAMETER = "anyoneGroup";
    private final System2 system;

    public PermissionTemplateDao(System2 system) {
        this.system = system;
    }

    public List<String> selectUserLoginsByQueryAndTemplate(DbSession session, PermissionQuery query, long templateId) {
        return PermissionTemplateDao.mapper(session).selectUserLoginsByQueryAndTemplate(query, templateId, new RowBounds(query.getPageOffset(), query.getPageSize()));
    }

    public int countUserLoginsByQueryAndTemplate(DbSession session, PermissionQuery query, long templateId) {
        return PermissionTemplateDao.mapper(session).countUserLoginsByQueryAndTemplate(query, templateId);
    }

    public List<PermissionTemplateUserDto> selectUserPermissionsByTemplateIdAndUserLogins(DbSession dbSession, long templateId, List<String> logins) {
        return DatabaseUtils.executeLargeInputs(logins, l -> PermissionTemplateDao.mapper(dbSession).selectUserPermissionsByTemplateIdAndUserLogins(templateId, (List<String>)l));
    }

    public List<PermissionTemplateUserDto> selectUserPermissionsByTemplateId(DbSession dbSession, long templateId) {
        return PermissionTemplateDao.mapper(dbSession).selectUserPermissionsByTemplateIdAndUserLogins(templateId, Collections.emptyList());
    }

    public List<String> selectGroupNamesByQueryAndTemplate(DbSession session, PermissionQuery query, long templateId) {
        return PermissionTemplateDao.mapper(session).selectGroupNamesByQueryAndTemplate(templateId, query, new RowBounds(query.getPageOffset(), query.getPageSize()));
    }

    public int countGroupNamesByQueryAndTemplate(DbSession session, PermissionQuery query, String organizationUuid, long templateId) {
        return PermissionTemplateDao.mapper(session).countGroupNamesByQueryAndTemplate(organizationUuid, query, templateId);
    }

    public List<PermissionTemplateGroupDto> selectGroupPermissionsByTemplateIdAndGroupNames(DbSession dbSession, long templateId, List<String> groups) {
        return DatabaseUtils.executeLargeInputs(groups, g -> PermissionTemplateDao.mapper(dbSession).selectGroupPermissionsByTemplateIdAndGroupNames(templateId, (List<String>)g));
    }

    public List<PermissionTemplateGroupDto> selectGroupPermissionsByTemplateId(DbSession dbSession, long templateId) {
        return PermissionTemplateDao.mapper(dbSession).selectGroupPermissionsByTemplateIdAndGroupNames(templateId, Collections.emptyList());
    }

    public boolean hasGroupsWithPermission(DbSession dbSession, long templateId, String permission, @Nullable Integer groupId) {
        return PermissionTemplateDao.mapper(dbSession).countGroupsWithPermission(templateId, permission, groupId) > 0;
    }

    @CheckForNull
    public PermissionTemplateDto selectByUuid(DbSession session, String templateUuid) {
        return PermissionTemplateDao.mapper(session).selectByUuid(templateUuid);
    }

    public List<PermissionTemplateDto> selectAll(DbSession session, String organizationUuid, @Nullable String nameMatch) {
        String upperCaseNameLikeSql = nameMatch != null ? PermissionTemplateDao.toUppercaseSqlQuery(nameMatch) : null;
        return PermissionTemplateDao.mapper(session).selectAll(organizationUuid, upperCaseNameLikeSql);
    }

    private static String toUppercaseSqlQuery(String nameMatch) {
        String wildcard = "%";
        return String.format("%s%s%s", wildcard, nameMatch.toUpperCase(Locale.ENGLISH), wildcard);
    }

    public PermissionTemplateDto insert(DbSession session, PermissionTemplateDto dto) {
        PermissionTemplateDao.mapper(session).insert(dto);
        return dto;
    }

    public void usersCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds, ResultHandler<CountByTemplateAndPermissionDto> resultHandler) {
        HashMap parameters = new HashMap(1);
        DatabaseUtils.executeLargeInputsWithoutOutput(templateIds, partitionedTemplateIds -> {
            parameters.put("templateIds", partitionedTemplateIds);
            PermissionTemplateDao.mapper(dbSession).usersCountByTemplateIdAndPermission(parameters, resultHandler);
        });
    }

    public void groupsCountByTemplateIdAndPermission(DbSession dbSession, List<Long> templateIds, ResultHandler<CountByTemplateAndPermissionDto> resultHandler) {
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put(ANYONE_GROUP_PARAMETER, "Anyone");
        DatabaseUtils.executeLargeInputsWithoutOutput(templateIds, partitionedTemplateIds -> {
            parameters.put("templateIds", (String)partitionedTemplateIds);
            PermissionTemplateDao.mapper(dbSession).groupsCountByTemplateIdAndPermission(parameters, resultHandler);
        });
    }

    public List<PermissionTemplateGroupDto> selectAllGroupPermissionTemplatesByGroupId(DbSession dbSession, long groupId) {
        return PermissionTemplateDao.mapper(dbSession).selectAllGroupPermissionTemplatesByGroupId(groupId);
    }

    public void deleteById(DbSession session, long templateId) {
        PermissionTemplateMapper mapper = PermissionTemplateDao.mapper(session);
        mapper.deleteUserPermissionsByTemplateId(templateId);
        mapper.deleteGroupPermissionsByTemplateId(templateId);
        ((PermissionTemplateCharacteristicMapper)session.getMapper(PermissionTemplateCharacteristicMapper.class)).deleteByTemplateId(templateId);
        mapper.deleteById(templateId);
    }

    public PermissionTemplateDto update(DbSession session, PermissionTemplateDto permissionTemplate) {
        PermissionTemplateDao.mapper(session).update(permissionTemplate);
        return permissionTemplate;
    }

    public void insertUserPermission(DbSession session, Long templateId, Integer userId, String permission) {
        PermissionTemplateUserDto permissionTemplateUser = new PermissionTemplateUserDto().setTemplateId(templateId).setUserId(userId).setPermission(permission).setCreatedAt(this.now()).setUpdatedAt(this.now());
        PermissionTemplateDao.mapper(session).insertUserPermission(permissionTemplateUser);
        session.commit();
    }

    public void deleteUserPermission(DbSession session, Long templateId, Integer userId, String permission) {
        PermissionTemplateUserDto permissionTemplateUser = new PermissionTemplateUserDto().setTemplateId(templateId).setPermission(permission).setUserId(userId);
        PermissionTemplateDao.mapper(session).deleteUserPermission(permissionTemplateUser);
        session.commit();
    }

    public void deleteUserPermissionsByOrganization(DbSession dbSession, String organizationUuid, int userId) {
        PermissionTemplateDao.mapper(dbSession).deleteUserPermissionsByOrganization(organizationUuid, userId);
    }

    public void deleteUserPermissionsByUserId(DbSession dbSession, int userId) {
        PermissionTemplateDao.mapper(dbSession).deleteUserPermissionsByUserId(userId);
    }

    public void insertGroupPermission(DbSession session, long templateId, @Nullable Integer groupId, String permission) {
        PermissionTemplateGroupDto permissionTemplateGroup = new PermissionTemplateGroupDto().setTemplateId(templateId).setPermission(permission).setGroupId(groupId).setCreatedAt(this.now()).setUpdatedAt(this.now());
        PermissionTemplateDao.mapper(session).insertGroupPermission(permissionTemplateGroup);
    }

    public void insertGroupPermission(DbSession session, PermissionTemplateGroupDto permissionTemplateGroup) {
        PermissionTemplateDao.mapper(session).insertGroupPermission(permissionTemplateGroup);
    }

    public void deleteGroupPermission(DbSession session, Long templateId, @Nullable Integer groupId, String permission) {
        PermissionTemplateGroupDto permissionTemplateGroup = new PermissionTemplateGroupDto().setTemplateId(templateId).setPermission(permission).setGroupId(groupId);
        PermissionTemplateDao.mapper(session).deleteGroupPermission(permissionTemplateGroup);
        session.commit();
    }

    public PermissionTemplateDto selectByName(DbSession dbSession, String organizationUuid, String name) {
        return PermissionTemplateDao.mapper(dbSession).selectByName(organizationUuid, name.toUpperCase(Locale.ENGLISH));
    }

    public List<String> selectPotentialPermissionsByUserIdAndTemplateId(DbSession dbSession, @Nullable Integer currentUserId, long templateId) {
        return PermissionTemplateDao.mapper(dbSession).selectPotentialPermissionsByUserIdAndTemplateId(currentUserId, templateId);
    }

    public void deleteByGroup(DbSession session, int groupId) {
        ((PermissionTemplateMapper)session.getMapper(PermissionTemplateMapper.class)).deleteByGroupId(groupId);
    }

    private Date now() {
        return new Date(this.system.now());
    }

    private static PermissionTemplateMapper mapper(DbSession session) {
        return (PermissionTemplateMapper)session.getMapper(PermissionTemplateMapper.class);
    }

    public void deleteByOrganization(DbSession dbSession, String organizationUuid) {
        PermissionTemplateMapper templateMapper = PermissionTemplateDao.mapper(dbSession);
        PermissionTemplateCharacteristicMapper templateCharacteristicMapper = (PermissionTemplateCharacteristicMapper)dbSession.getMapper(PermissionTemplateCharacteristicMapper.class);
        List<Long> templateIds = templateMapper.selectTemplateIdsByOrganization(organizationUuid);
        DatabaseUtils.executeLargeInputsWithoutOutput(templateIds, subList -> {
            templateCharacteristicMapper.deleteByTemplateIds((List<Long>)subList);
            templateMapper.deleteGroupPermissionsByTemplateIds((List<Long>)subList);
            templateMapper.deleteUserPermissionsByTemplateIds((List<Long>)subList);
            templateMapper.deleteByIds((List<Long>)subList);
        });
    }
}

