/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.property;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.MyBatis;
import org.sonar.db.property.PropertiesMapper;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.db.property.Subscriber;

public class PropertiesDao
implements Dao {
    private static final String NOTIFICATION_PREFIX = "notification.";
    private static final int VARCHAR_MAXSIZE = 4000;
    private final MyBatis mybatis;
    private final System2 system2;

    public PropertiesDao(MyBatis mybatis, System2 system2) {
        this.mybatis = mybatis;
        this.system2 = system2;
    }

    public Set<Subscriber> findUsersForNotification(String notificationDispatcherKey, String notificationChannelKey, @Nullable String projectKey) {
        try (DbSession session = this.mybatis.openSession(false);){
            Set<Subscriber> set = PropertiesDao.getMapper(session).findUsersForNotification(NOTIFICATION_PREFIX + notificationDispatcherKey + "." + notificationChannelKey, projectKey);
            return set;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasProjectNotificationSubscribersForDispatchers(String projectUuid, Collection<String> dispatcherKeys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PreparedStatement createStatement(String projectUuid, Collection<String> dispatcherKeys, Connection connection) throws SQLException {
        String sql = "SELECT count(1) FROM properties pp left outer join projects pj on pp.resource_id = pj.id where pp.user_id is not null and (pp.resource_id is null or pj.uuid=?) and (" + StringUtils.repeat((String)"pp.prop_key like ?", (String)" or ", (int)dispatcherKeys.size()) + ")";
        PreparedStatement res = connection.prepareStatement(sql);
        res.setString(1, projectUuid);
        int index = 2;
        for (String dispatcherKey : dispatcherKeys) {
            res.setString(index, NOTIFICATION_PREFIX + dispatcherKey + ".%");
            ++index;
        }
        return res;
    }

    public List<PropertyDto> selectGlobalProperties() {
        try (DbSession session = this.mybatis.openSession(false);){
            List<PropertyDto> list = this.selectGlobalProperties(session);
            return list;
        }
    }

    public List<PropertyDto> selectGlobalProperties(DbSession session) {
        return PropertiesDao.getMapper(session).selectGlobalProperties();
    }

    @CheckForNull
    public PropertyDto selectGlobalProperty(DbSession session, String propertyKey) {
        return PropertiesDao.getMapper(session).selectByKey(new PropertyDto().setKey(propertyKey));
    }

    @CheckForNull
    public PropertyDto selectGlobalProperty(String propertyKey) {
        try (DbSession session = this.mybatis.openSession(false);){
            PropertyDto propertyDto = this.selectGlobalProperty(session, propertyKey);
            return propertyDto;
        }
    }

    public List<PropertyDto> selectProjectProperties(DbSession session, String projectKey) {
        return PropertiesDao.getMapper(session).selectProjectProperties(projectKey);
    }

    public List<PropertyDto> selectProjectProperties(String resourceKey) {
        try (DbSession session = this.mybatis.openSession(false);){
            List<PropertyDto> list = this.selectProjectProperties(session, resourceKey);
            return list;
        }
    }

    @CheckForNull
    public PropertyDto selectProjectProperty(long componentId, String propertyKey) {
        try (DbSession session = this.mybatis.openSession(false);){
            PropertyDto propertyDto = this.selectProjectProperty(session, componentId, propertyKey);
            return propertyDto;
        }
    }

    @CheckForNull
    public PropertyDto selectProjectProperty(DbSession dbSession, long componentId, String propertyKey) {
        return PropertiesDao.getMapper(dbSession).selectByKey(new PropertyDto().setKey(propertyKey).setResourceId(componentId));
    }

    public List<PropertyDto> selectByQuery(PropertyQuery query, DbSession session) {
        return PropertiesDao.getMapper(session).selectByQuery(query);
    }

    public List<PropertyDto> selectGlobalPropertiesByKeys(DbSession session, Set<String> keys) {
        return DatabaseUtils.executeLargeInputs(keys, partitionKeys -> PropertiesDao.getMapper(session).selectByKeys((List<String>)partitionKeys));
    }

    public List<PropertyDto> selectPropertiesByKeysAndComponentIds(DbSession session, Set<String> keys, Set<Long> componentIds) {
        return DatabaseUtils.executeLargeInputs(keys, partitionKeys -> DatabaseUtils.executeLargeInputs((Collection)componentIds, partitionComponentIds -> PropertiesDao.getMapper(session).selectByKeysAndComponentIds((List<String>)partitionKeys, (List<Long>)partitionComponentIds)));
    }

    public List<PropertyDto> selectPropertiesByComponentIds(DbSession session, Set<Long> componentIds) {
        return DatabaseUtils.executeLargeInputs(componentIds, PropertiesDao.getMapper(session)::selectByComponentIds);
    }

    public List<PropertyDto> selectByKeyAndMatchingValue(DbSession session, String key, String value) {
        return PropertiesDao.getMapper(session).selectByKeyAndMatchingValue(key, value);
    }

    public List<PropertyDto> selectByKeyAndUserIdAndComponentQualifier(DbSession session, String key, int userId, String qualifier) {
        return PropertiesDao.getMapper(session).selectByKeyAndUserIdAndComponentQualifier(key, userId, qualifier);
    }

    public void saveProperty(DbSession session, PropertyDto property) {
        this.save(PropertiesDao.getMapper(session), property.getKey(), property.getUserId(), property.getResourceId(), property.getValue());
    }

    private void save(PropertiesMapper mapper, String key, @Nullable Integer userId, @Nullable Long componentId, @Nullable String value) {
        PropertiesDao.checkKey(key);
        long now = this.system2.now();
        mapper.delete(key, userId, componentId);
        if (PropertiesDao.isEmpty(value)) {
            mapper.insertAsEmpty(key, userId, componentId, now);
        } else if (PropertiesDao.mustBeStoredInClob(value)) {
            mapper.insertAsClob(key, userId, componentId, value, now);
        } else {
            mapper.insertAsText(key, userId, componentId, value, now);
        }
    }

    private static boolean mustBeStoredInClob(String value) {
        return value.length() > 4000;
    }

    private static void checkKey(@Nullable String key) {
        Preconditions.checkArgument((!PropertiesDao.isEmpty(key) ? 1 : 0) != 0, (Object)"key can't be null nor empty");
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    public void saveProperty(PropertyDto property) {
        try (DbSession session = this.mybatis.openSession(false);){
            this.saveProperty(session, property);
            session.commit();
        }
    }

    public int deleteByQuery(DbSession dbSession, PropertyQuery query) {
        return PropertiesDao.getMapper(dbSession).deleteByQuery(query);
    }

    public int delete(DbSession dbSession, PropertyDto dto) {
        return PropertiesDao.getMapper(dbSession).delete(dto.getKey(), dto.getUserId(), dto.getResourceId());
    }

    public void deleteProjectProperty(String key, Long projectId) {
        try (DbSession session = this.mybatis.openSession(false);){
            this.deleteProjectProperty(key, projectId, session);
            session.commit();
        }
    }

    public void deleteProjectProperty(String key, Long projectId, DbSession session) {
        PropertiesDao.getMapper(session).deleteProjectProperty(key, projectId);
    }

    public void deleteProjectProperties(String key, String value, DbSession session) {
        PropertiesDao.getMapper(session).deleteProjectProperties(key, value);
    }

    public void deleteProjectProperties(String key, String value) {
        try (DbSession session = this.mybatis.openSession(false);){
            this.deleteProjectProperties(key, value, session);
            session.commit();
        }
    }

    public void deleteGlobalProperty(String key, DbSession session) {
        PropertiesDao.getMapper(session).deleteGlobalProperty(key);
    }

    public void deleteGlobalProperty(String key) {
        try (DbSession session = this.mybatis.openSession(false);){
            this.deleteGlobalProperty(key, session);
            session.commit();
        }
    }

    public void deleteByOrganizationAndUser(DbSession dbSession, String organizationUuid, int userId) {
        List<Long> ids = PropertiesDao.getMapper(dbSession).selectIdsByOrganizationAndUser(organizationUuid, userId);
        DatabaseUtils.executeLargeInputsWithoutOutput(ids, subList -> PropertiesDao.getMapper(dbSession).deleteByIds((List<Long>)subList));
    }

    public void deleteByOrganizationAndMatchingLogin(DbSession dbSession, String organizationUuid, String login, List<String> propertyKeys) {
        List<Long> ids = PropertiesDao.getMapper(dbSession).selectIdsByOrganizationAndMatchingLogin(organizationUuid, login, propertyKeys);
        DatabaseUtils.executeLargeInputsWithoutOutput(ids, list -> PropertiesDao.getMapper(dbSession).deleteByIds((List<Long>)list));
    }

    public void deleteByKeyAndValue(DbSession dbSession, String key, String value) {
        PropertiesDao.getMapper(dbSession).deleteByKeyAndValue(key, value);
    }

    public void saveGlobalProperties(Map<String, String> properties) {
        try (DbSession session = this.mybatis.openSession(false);){
            PropertiesMapper mapper = PropertiesDao.getMapper(session);
            properties.entrySet().forEach(entry -> {
                mapper.deleteGlobalProperty((String)entry.getKey());
                this.save(mapper, (String)entry.getKey(), null, null, (String)entry.getValue());
            });
            session.commit();
        }
    }

    public void renamePropertyKey(String oldKey, String newKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)oldKey) ? 1 : 0) != 0, (Object)"Old property key must not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newKey) ? 1 : 0) != 0, (Object)"New property key must not be empty");
        if (!newKey.equals(oldKey)) {
            try (DbSession session = this.mybatis.openSession(false);){
                PropertiesDao.getMapper(session).renamePropertyKey(oldKey, newKey);
                session.commit();
            }
        }
    }

    private static PropertiesMapper getMapper(DbSession session) {
        return (PropertiesMapper)session.getMapper(PropertiesMapper.class);
    }
}

