/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.db.DbSession;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.IdUuidPairs;
import org.sonar.db.purge.PurgeMapper;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.db.purge.PurgeSnapshotQuery;

class PurgeCommands {
    private static final int MAX_SNAPSHOTS_PER_QUERY = 1000;
    private static final int MAX_RESOURCES_PER_QUERY = 1000;
    private final DbSession session;
    private final PurgeMapper purgeMapper;
    private final PurgeProfiler profiler;

    PurgeCommands(DbSession session, PurgeMapper purgeMapper, PurgeProfiler profiler) {
        this.session = session;
        this.purgeMapper = purgeMapper;
        this.profiler = profiler;
    }

    @VisibleForTesting
    PurgeCommands(DbSession session, PurgeProfiler profiler) {
        this(session, (PurgeMapper)session.getMapper(PurgeMapper.class), profiler);
    }

    List<String> selectSnapshotUuids(PurgeSnapshotQuery query) {
        return this.purgeMapper.selectAnalysisIdsAndUuids(query).stream().map(IdUuidPair::getUuid).collect(Collectors.toList());
    }

    List<IdUuidPair> selectSnapshotIdUuids(PurgeSnapshotQuery query) {
        return this.purgeMapper.selectAnalysisIdsAndUuids(query);
    }

    void deleteAnalyses(String rootComponentUuid) {
        this.profiler.start("deleteAnalyses (event_component_changes)");
        this.purgeMapper.deleteEventComponentChangesByComponentUuid(rootComponentUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (events)");
        this.purgeMapper.deleteEventsByComponentUuid(rootComponentUuid);
        this.session.commit();
        this.profiler.stop();
        List analysisUuidsPartitions = Lists.partition(IdUuidPairs.uuids(this.purgeMapper.selectAnalysisIdsAndUuids(new PurgeSnapshotQuery(rootComponentUuid))), (int)1000);
        this.deleteAnalysisDuplications(analysisUuidsPartitions);
        this.profiler.start("deleteAnalyses (project_measures)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisMeasures);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (snapshots)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalyses);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (analysis_properties)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisProperties);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteAnalyses(PurgeSnapshotQuery ... queries) {
        List<IdUuidPair> snapshotIds = Arrays.stream(queries).flatMap(q -> this.purgeMapper.selectAnalysisIdsAndUuids((PurgeSnapshotQuery)q).stream()).collect(Collectors.toList());
        this.deleteAnalyses(snapshotIds);
    }

    @VisibleForTesting
    void deleteAnalyses(List<IdUuidPair> analysisIdUuids) {
        List analysisUuidsPartitions = Lists.partition(IdUuidPairs.uuids(analysisIdUuids), (int)1000);
        this.deleteAnalysisDuplications(analysisUuidsPartitions);
        this.profiler.start("deleteAnalyses (event_component_changes)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisEventComponentChanges);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (events)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisEvents);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (project_measures)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisMeasures);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (snapshots)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalyses);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteAnalyses (analysis_properties)");
        analysisUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisProperties);
        this.session.commit();
        this.profiler.stop();
    }

    void purgeAnalyses(List<IdUuidPair> analysisUuids) {
        List analysisUuidsPartitions = Lists.partition(IdUuidPairs.uuids(analysisUuids), (int)1000);
        this.deleteAnalysisDuplications(analysisUuidsPartitions);
        this.profiler.start("deleteSnapshotWastedMeasures (project_measures)");
        List<Long> metricIdsWithoutHistoricalData = this.purgeMapper.selectMetricIdsWithoutHistoricalData();
        if (!metricIdsWithoutHistoricalData.isEmpty()) {
            analysisUuidsPartitions.forEach(analysisUuidsPartition -> this.purgeMapper.deleteAnalysisWastedMeasures((List<String>)analysisUuidsPartition, metricIdsWithoutHistoricalData));
            this.session.commit();
        }
        this.profiler.stop();
        this.profiler.start("updatePurgeStatusToOne (snapshots)");
        analysisUuidsPartitions.forEach(this.purgeMapper::updatePurgeStatusToOne);
        this.session.commit();
        this.profiler.stop();
    }

    private void deleteAnalysisDuplications(List<List<String>> snapshotUuidsPartitions) {
        this.profiler.start("deleteAnalysisDuplications (duplications_index)");
        snapshotUuidsPartitions.forEach(this.purgeMapper::deleteAnalysisDuplications);
        this.session.commit();
        this.profiler.stop();
    }

    void deletePermissions(long rootId) {
        this.profiler.start("deletePermissions (group_roles)");
        this.purgeMapper.deleteGroupRolesByComponentId(rootId);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deletePermissions (user_roles)");
        this.purgeMapper.deleteUserRolesByComponentId(rootId);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteIssues(String rootUuid) {
        this.profiler.start("deleteIssues (issue_changes)");
        this.purgeMapper.deleteIssueChangesByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteIssues (issues)");
        this.purgeMapper.deleteIssuesByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteLinks(String rootUuid) {
        this.profiler.start("deleteLinks (project_links)");
        this.purgeMapper.deleteProjectLinksByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteByRootAndModulesOrSubviews(List<IdUuidPair> rootAndModulesOrSubviewsIds) {
        if (rootAndModulesOrSubviewsIds.isEmpty()) {
            return;
        }
        List idPartitions = Lists.partition(IdUuidPairs.ids(rootAndModulesOrSubviewsIds), (int)1000);
        List uuidsPartitions = Lists.partition(IdUuidPairs.uuids(rootAndModulesOrSubviewsIds), (int)1000);
        this.profiler.start("deleteByRootAndModulesOrSubviews (properties)");
        idPartitions.forEach(this.purgeMapper::deletePropertiesByComponentIds);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteByRootAndModulesOrSubviews (manual_measures)");
        uuidsPartitions.forEach(this.purgeMapper::deleteManualMeasuresByComponentUuids);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteComponents(String rootUuid) {
        this.profiler.start("deleteComponents (projects)");
        this.purgeMapper.deleteComponentsByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteComponents(List<String> componentUuids) {
        if (componentUuids.isEmpty()) {
            return;
        }
        this.profiler.start("deleteComponents (projects)");
        Lists.partition(componentUuids, (int)1000).forEach(this.purgeMapper::deleteComponentsByUuids);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteComponentMeasures(List<String> componentUuids) {
        if (componentUuids.isEmpty()) {
            return;
        }
        this.profiler.start("deleteComponentMeasures (project_measures)");
        Lists.partition(componentUuids, (int)1000).forEach(this.purgeMapper::fullDeleteComponentMeasures);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteComponentMeasures(List<String> analysisUuids, List<String> componentUuids) {
        if (analysisUuids.isEmpty() || componentUuids.isEmpty()) {
            return;
        }
        List analysisUuidsPartitions = Lists.partition(analysisUuids, (int)1000);
        List componentUuidsPartitions = Lists.partition(componentUuids, (int)1000);
        this.profiler.start("deleteComponentMeasures");
        for (List analysisUuidsPartition : analysisUuidsPartitions) {
            for (List componentUuidsPartition : componentUuidsPartitions) {
                this.purgeMapper.deleteComponentMeasures(analysisUuidsPartition, componentUuidsPartition);
            }
        }
        this.session.commit();
        this.profiler.stop();
    }

    void deleteFileSources(String rootUuid) {
        this.profiler.start("deleteFileSources (file_sources)");
        this.purgeMapper.deleteFileSourcesByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteCeActivity(String rootUuid) {
        this.profiler.start("deleteCeActivity (ce_scanner_context)");
        this.purgeMapper.deleteCeScannerContextOfCeActivityByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeActivity (ce_task_characteristics)");
        this.purgeMapper.deleteCeTaskCharacteristicsOfCeActivityByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeActivity (ce_task_input)");
        this.purgeMapper.deleteCeTaskInputOfCeActivityByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeActivity (ce_task_message)");
        this.purgeMapper.deleteCeTaskMessageOfCeActivityByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeActivity (ce_activity)");
        this.purgeMapper.deleteCeActivityByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteCeQueue(String rootUuid) {
        this.profiler.start("deleteCeQueue (ce_scanner_context)");
        this.purgeMapper.deleteCeScannerContextOfCeQueueByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeQueue (ce_task_characteristics)");
        this.purgeMapper.deleteCeTaskCharacteristicsOfCeQueueByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeQueue (ce_task_input)");
        this.purgeMapper.deleteCeTaskInputOfCeQueueByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeQueue (ce_task_message)");
        this.purgeMapper.deleteCeTaskMessageOfCeQueueByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
        this.profiler.start("deleteCeQueue (ce_queue)");
        this.purgeMapper.deleteCeQueueByRootUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteWebhooks(String rootUuid) {
        this.profiler.start("deleteWebhooks (webhooks)");
        this.purgeMapper.deleteWebhooksByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteWebhookDeliveries(String rootUuid) {
        this.profiler.start("deleteWebhookDeliveries (webhook_deliveries)");
        this.purgeMapper.deleteWebhookDeliveriesByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteProjectMappings(String rootUuid) {
        this.profiler.start("deleteProjectMappings (project_mappings)");
        this.purgeMapper.deleteProjectMappingsByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteProjectAlmBindings(String rootUuid) {
        this.profiler.start("deleteProjectAlmBindings (project_alm_bindings)");
        this.purgeMapper.deleteProjectAlmBindingsByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteBranch(String rootUuid) {
        this.profiler.start("deleteBranch (project_branches)");
        this.purgeMapper.deleteBranchByUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }

    void deleteLiveMeasures(String rootUuid) {
        this.profiler.start("deleteLiveMeasures (live_measures)");
        this.purgeMapper.deleteLiveMeasuresByProjectUuid(rootUuid);
        this.session.commit();
        this.profiler.stop();
    }
}

