/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchMapper;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.PurgeCommands;
import org.sonar.db.purge.PurgeConfiguration;
import org.sonar.db.purge.PurgeListener;
import org.sonar.db.purge.PurgeMapper;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.db.purge.PurgeSnapshotQuery;
import org.sonar.db.purge.PurgeableAnalysisDto;

public class PurgeDao
implements Dao {
    private static final Logger LOG = Loggers.get(PurgeDao.class);
    private static final String[] UNPROCESSED_STATUS = new String[]{"U"};
    private static final Set<String> QUALIFIERS_PROJECT_VIEW = ImmutableSet.of((Object)"TRK", (Object)"VW");
    private static final Set<String> QUALIFIERS_MODULE_SUBVIEW = ImmutableSet.of((Object)"BRC", (Object)"SVW");
    private static final String SCOPE_PROJECT = "PRJ";
    private final ComponentDao componentDao;
    private final System2 system2;

    public PurgeDao(ComponentDao componentDao, System2 system2) {
        this.componentDao = componentDao;
        this.system2 = system2;
    }

    public void purge(DbSession session, PurgeConfiguration conf, PurgeListener listener, PurgeProfiler profiler) {
        PurgeMapper mapper = (PurgeMapper)session.getMapper(PurgeMapper.class);
        PurgeCommands commands = new PurgeCommands(session, mapper, profiler);
        String rootUuid = conf.rootUuid();
        PurgeDao.deleteAbortedAnalyses(rootUuid, commands);
        this.deleteDataOfComponentsWithoutHistoricalData(session, rootUuid, conf.getScopesWithoutHistoricalData(), commands);
        PurgeDao.purgeAnalyses(commands, rootUuid);
        this.purgeDisabledComponents(session, conf, listener);
        PurgeDao.deleteOldClosedIssues(conf, mapper, listener);
        PurgeDao.purgeStaleBranches(commands, conf, mapper, rootUuid);
    }

    private static void purgeStaleBranches(PurgeCommands commands, PurgeConfiguration conf, PurgeMapper mapper, String rootUuid) {
        Optional<Date> maxDate = conf.maxLiveDateOfInactiveShortLivingBranches();
        if (!maxDate.isPresent()) {
            return;
        }
        LOG.debug("<- Purge stale branches");
        List<String> branchUuids = mapper.selectStaleShortLivingBranchesAndPullRequests(conf.projectUuid(), DateUtils.dateToLong((Date)maxDate.get()));
        for (String branchUuid : branchUuids) {
            if (rootUuid.equals(branchUuid)) continue;
            PurgeDao.deleteRootComponent(branchUuid, mapper, commands);
        }
    }

    private static void purgeAnalyses(PurgeCommands commands, String rootUuid) {
        List<IdUuidPair> analysisUuids = commands.selectSnapshotIdUuids(new PurgeSnapshotQuery(rootUuid).setIslast(false).setNotPurged(true));
        commands.purgeAnalyses(analysisUuids);
    }

    private static void deleteOldClosedIssues(PurgeConfiguration conf, PurgeMapper mapper, PurgeListener listener) {
        Date toDate = conf.maxLiveDateOfClosedIssues();
        String rootUuid = conf.rootUuid();
        List<String> issueKeys = mapper.selectOldClosedIssueKeys(rootUuid, DateUtils.dateToLong((Date)toDate));
        DatabaseUtils.executeLargeInputs(issueKeys, input -> {
            mapper.deleteIssueChangesFromIssueKeys((List<String>)input);
            return Collections.emptyList();
        });
        DatabaseUtils.executeLargeInputs(issueKeys, input -> {
            mapper.deleteIssuesFromKeys((List<String>)input);
            return Collections.emptyList();
        });
        listener.onIssuesRemoval(rootUuid, issueKeys);
    }

    private static void deleteAbortedAnalyses(String rootUuid, PurgeCommands commands) {
        LOG.debug("<- Delete aborted builds");
        PurgeSnapshotQuery query = new PurgeSnapshotQuery(rootUuid).setIslast(false).setStatus(UNPROCESSED_STATUS);
        commands.deleteAnalyses(query);
    }

    private void deleteDataOfComponentsWithoutHistoricalData(DbSession dbSession, String rootUuid, Collection<String> scopesWithoutHistoricalData, PurgeCommands purgeCommands) {
        if (scopesWithoutHistoricalData.isEmpty()) {
            return;
        }
        List<String> analysisUuids = purgeCommands.selectSnapshotUuids(new PurgeSnapshotQuery(rootUuid).setIslast(false).setNotPurged(true));
        List componentWithoutHistoricalDataUuids = (List)this.componentDao.selectDescendants(dbSession, ComponentTreeQuery.builder().setBaseUuid(rootUuid).setScopes(scopesWithoutHistoricalData).setStrategy(ComponentTreeQuery.Strategy.LEAVES).build()).stream().map(ComponentDto::uuid).collect(MoreCollectors.toList());
        purgeCommands.deleteComponentMeasures(analysisUuids, componentWithoutHistoricalDataUuids);
    }

    private void purgeDisabledComponents(DbSession session, PurgeConfiguration conf, PurgeListener listener) {
        PurgeMapper mapper = PurgeDao.mapper(session);
        DatabaseUtils.executeLargeInputs(conf.getDisabledComponentUuids(), input -> {
            mapper.deleteFileSourcesByFileUuid((List<String>)input);
            mapper.resolveComponentIssuesNotAlreadyResolved((List<String>)input, this.system2.now());
            mapper.deleteLiveMeasuresByComponentUuids((List<String>)input);
            return Collections.emptyList();
        });
        listener.onComponentsDisabling(conf.rootUuid(), conf.getDisabledComponentUuids());
        session.commit();
    }

    public List<PurgeableAnalysisDto> selectPurgeableAnalyses(String componentUuid, DbSession session) {
        PurgeMapper mapper = PurgeDao.mapper(session);
        Stream allPurgeableAnalyses = Stream.concat(mapper.selectPurgeableAnalysesWithEvents(componentUuid).stream(), mapper.selectPurgeableAnalysesWithoutEvents(componentUuid).stream());
        return (List)allPurgeableAnalyses.filter(new ManualBaselineAnalysisFilter(mapper, componentUuid)).sorted().collect(MoreCollectors.toList());
    }

    public void deleteBranch(DbSession session, String uuid) {
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeMapper purgeMapper = PurgeDao.mapper(session);
        PurgeCommands purgeCommands = new PurgeCommands(session, profiler);
        PurgeDao.deleteRootComponent(uuid, purgeMapper, purgeCommands);
    }

    public void deleteProject(DbSession session, String uuid) {
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeMapper purgeMapper = PurgeDao.mapper(session);
        PurgeCommands purgeCommands = new PurgeCommands(session, profiler);
        ((BranchMapper)session.getMapper(BranchMapper.class)).selectByProjectUuid(uuid).stream().filter(branch -> !uuid.equals(branch.getUuid())).forEach(branch -> PurgeDao.deleteRootComponent(branch.getUuid(), purgeMapper, purgeCommands));
        PurgeDao.deleteRootComponent(uuid, purgeMapper, purgeCommands);
    }

    private static void deleteRootComponent(String rootUuid, PurgeMapper mapper, PurgeCommands commands) {
        List<IdUuidPair> rootAndModulesOrSubviews = mapper.selectRootAndModulesOrSubviewsByProjectUuid(rootUuid);
        long rootId = rootAndModulesOrSubviews.stream().filter(pair -> pair.getUuid().equals(rootUuid)).map(IdUuidPair::getId).findFirst().orElseThrow(() -> new IllegalArgumentException("Couldn't find root component with uuid " + rootUuid));
        commands.deletePermissions(rootId);
        commands.deleteLinks(rootUuid);
        commands.deleteAnalyses(rootUuid);
        commands.deleteByRootAndModulesOrSubviews(rootAndModulesOrSubviews);
        commands.deleteComponents(rootUuid);
        commands.deleteIssues(rootUuid);
        commands.deleteFileSources(rootUuid);
        commands.deleteCeActivity(rootUuid);
        commands.deleteCeQueue(rootUuid);
        commands.deleteWebhooks(rootUuid);
        commands.deleteWebhookDeliveries(rootUuid);
        commands.deleteProjectMappings(rootUuid);
        commands.deleteProjectAlmBindings(rootUuid);
        commands.deleteBranch(rootUuid);
        commands.deleteLiveMeasures(rootUuid);
    }

    public void deleteNonRootComponentsInView(DbSession dbSession, Collection<ComponentDto> components) {
        Set nonRootComponents = (Set)components.stream().filter(PurgeDao::isNotRoot).collect(MoreCollectors.toSet());
        if (nonRootComponents.isEmpty()) {
            return;
        }
        PurgeProfiler profiler = new PurgeProfiler();
        PurgeCommands purgeCommands = new PurgeCommands(dbSession, profiler);
        PurgeDao.deleteNonRootComponentsInView(nonRootComponents, purgeCommands);
    }

    private static void deleteNonRootComponentsInView(Set<ComponentDto> nonRootComponents, PurgeCommands purgeCommands) {
        List subviewsOrProjectCopies = (List)nonRootComponents.stream().filter(PurgeDao::isModuleOrSubview).map(PurgeDao::toIdUuidPair).collect(MoreCollectors.toList());
        purgeCommands.deleteByRootAndModulesOrSubviews(subviewsOrProjectCopies);
        List nonRootComponentUuids = (List)nonRootComponents.stream().map(ComponentDto::uuid).collect(MoreCollectors.toList((int)nonRootComponents.size()));
        purgeCommands.deleteComponentMeasures(nonRootComponentUuids);
        purgeCommands.deleteComponents(nonRootComponentUuids);
    }

    private static boolean isNotRoot(ComponentDto dto) {
        return !SCOPE_PROJECT.equals(dto.scope()) || !QUALIFIERS_PROJECT_VIEW.contains(dto.qualifier());
    }

    private static boolean isModuleOrSubview(ComponentDto dto) {
        return SCOPE_PROJECT.equals(dto.scope()) && QUALIFIERS_MODULE_SUBVIEW.contains(dto.qualifier());
    }

    private static IdUuidPair toIdUuidPair(ComponentDto dto) {
        return new IdUuidPair(dto.getId(), dto.uuid());
    }

    public void deleteAnalyses(DbSession session, PurgeProfiler profiler, List<IdUuidPair> analysisIdUuids) {
        new PurgeCommands(session, profiler).deleteAnalyses(analysisIdUuids);
    }

    private static PurgeMapper mapper(DbSession session) {
        return (PurgeMapper)session.getMapper(PurgeMapper.class);
    }

    private static final class ManualBaselineAnalysisFilter
    implements Predicate<PurgeableAnalysisDto> {
        private static final String[] NO_BASELINE = new String[]{null};
        private final PurgeMapper mapper;
        private final String componentUuid;
        private String[] manualBaselineAnalysisUuid;

        private ManualBaselineAnalysisFilter(PurgeMapper mapper, String componentUuid) {
            this.mapper = mapper;
            this.componentUuid = componentUuid;
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean test(PurgeableAnalysisDto purgeableAnalysisDto) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

