/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.purge.PurgeableAnalysisDto;
import org.sonar.db.purge.period.Filter;

class DeleteAllFilter
implements Filter {
    private final Date before;

    public DeleteAllFilter(Date before) {
        this.before = before;
    }

    @Override
    public List<PurgeableAnalysisDto> filter(List<PurgeableAnalysisDto> history) {
        ArrayList result = Lists.newArrayList();
        for (PurgeableAnalysisDto snapshot : history) {
            if (!snapshot.getDate().before(this.before)) continue;
            result.add(snapshot);
        }
        return result;
    }

    @Override
    public void log() {
        Loggers.get(this.getClass()).debug("-> Delete data prior to: {}", (Object)DateUtils.formatDate((Date)this.before));
    }
}

