/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.purge.PurgeableAnalysisDto;
import org.sonar.db.purge.period.Filter;
import org.sonar.db.purge.period.Interval;

class KeepOneFilter
implements Filter {
    private final Date start;
    private final Date end;
    private final int dateField;
    private final String label;

    KeepOneFilter(Date start, Date end, int calendarField, String label) {
        this.start = start;
        this.end = end;
        this.dateField = calendarField;
        this.label = label;
    }

    @Override
    public List<PurgeableAnalysisDto> filter(List<PurgeableAnalysisDto> history) {
        List<Interval> intervals = Interval.group(history, this.start, this.end, this.dateField);
        ArrayList result = Lists.newArrayList();
        for (Interval interval : intervals) {
            KeepOneFilter.appendSnapshotsToDelete(interval, result);
        }
        return result;
    }

    @Override
    public void log() {
        Loggers.get(this.getClass()).debug("-> Keep one snapshot per {} between {} and {}", new Object[]{this.label, DateUtils.formatDate((Date)this.start), DateUtils.formatDate((Date)this.end)});
    }

    private static void appendSnapshotsToDelete(Interval interval, List<PurgeableAnalysisDto> toDelete) {
        if (interval.count() > 1) {
            ArrayList deletables = Lists.newArrayList();
            ArrayList toKeep = Lists.newArrayList();
            for (PurgeableAnalysisDto snapshot : interval.get()) {
                if (KeepOneFilter.isDeletable(snapshot)) {
                    deletables.add(snapshot);
                    continue;
                }
                toKeep.add(snapshot);
            }
            if (!toKeep.isEmpty()) {
                toDelete.addAll(deletables);
            } else if (deletables.size() > 1) {
                toDelete.addAll(deletables.subList(0, deletables.size() - 1));
            }
        }
    }

    @VisibleForTesting
    static boolean isDeletable(PurgeableAnalysisDto snapshot) {
        return !snapshot.isLast() && !snapshot.hasEvents();
    }
}

