/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualitygate;

import java.util.Collection;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.db.qualitygate.QualityGateMapper;

public class QualityGateDao
implements Dao {
    public QualityGateDto insert(DbSession session, QualityGateDto newQualityGate) {
        QualityGateDao.mapper(session).insertQualityGate(newQualityGate.setCreatedAt(new Date()));
        return newQualityGate;
    }

    public void associate(DbSession dbSession, String uuid, OrganizationDto organization, QualityGateDto qualityGate) {
        QualityGateDao.mapper(dbSession).insertOrgQualityGate(uuid, organization.getUuid(), qualityGate.getUuid());
    }

    public Collection<QualityGateDto> selectAll(DbSession session, OrganizationDto organization) {
        return QualityGateDao.mapper(session).selectAll(organization.getUuid());
    }

    @CheckForNull
    public QualityGateDto selectByName(DbSession session, String name) {
        return QualityGateDao.mapper(session).selectByName(name);
    }

    @CheckForNull
    public QualityGateDto selectById(DbSession session, long id) {
        return QualityGateDao.mapper(session).selectById(id);
    }

    @CheckForNull
    public QGateWithOrgDto selectByOrganizationAndUuid(DbSession dbSession, OrganizationDto organization, String qualityGateUuid) {
        return QualityGateDao.mapper(dbSession).selectByUuidAndOrganization(qualityGateUuid, organization.getUuid());
    }

    @CheckForNull
    public QGateWithOrgDto selectByOrganizationAndName(DbSession session, OrganizationDto organization, String name) {
        return QualityGateDao.mapper(session).selectByNameAndOrganization(name, organization.getUuid());
    }

    @CheckForNull
    public QGateWithOrgDto selectByOrganizationAndId(DbSession session, OrganizationDto organization, long id) {
        return QualityGateDao.mapper(session).selectByIdAndOrganization(id, organization.getUuid());
    }

    public QGateWithOrgDto selectDefault(DbSession dbSession, OrganizationDto organization) {
        return QualityGateDao.mapper(dbSession).selectDefault(organization.getUuid());
    }

    public void delete(QualityGateDto qGate, DbSession session) {
        QualityGateDao.mapper(session).delete(qGate.getUuid());
        QualityGateDao.mapper(session).deleteOrgQualityGatesByQualityGateUuid(qGate.getUuid());
    }

    public void deleteByUuids(DbSession session, Collection<String> uuids) {
        QualityGateMapper mapper = QualityGateDao.mapper(session);
        DatabaseUtils.executeLargeUpdates(uuids, mapper::deleteByUuids);
    }

    public void deleteOrgQualityGatesByOrganization(DbSession session, OrganizationDto organization) {
        QualityGateDao.mapper(session).deleteOrgQualityGatesByOrganization(organization.getUuid());
    }

    public void update(QualityGateDto qGate, DbSession session) {
        QualityGateDao.mapper(session).update(qGate.setUpdatedAt(new Date()));
    }

    public void ensureOneBuiltInQualityGate(DbSession dbSession, String builtInName) {
        QualityGateDao.mapper(dbSession).ensureOneBuiltInQualityGate(builtInName);
    }

    public QualityGateDto selectBuiltIn(DbSession dbSession) {
        return QualityGateDao.mapper(dbSession).selectBuiltIn();
    }

    private static QualityGateMapper mapper(DbSession session) {
        return (QualityGateMapper)session.getMapper(QualityGateMapper.class);
    }
}

