/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import java.util.Collection;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.QProfileEditUsersDto;
import org.sonar.db.qualityprofile.QProfileEditUsersMapper;
import org.sonar.db.qualityprofile.SearchUsersQuery;
import org.sonar.db.qualityprofile.UserMembershipDto;
import org.sonar.db.user.UserDto;

public class QProfileEditUsersDao
implements Dao {
    private final System2 system2;

    public QProfileEditUsersDao(System2 system2) {
        this.system2 = system2;
    }

    public boolean exists(DbSession dbSession, QProfileDto profile, UserDto user) {
        return QProfileEditUsersDao.mapper(dbSession).selectByQProfileAndUser(profile.getKee(), user.getId()) != null;
    }

    public int countByQuery(DbSession dbSession, SearchUsersQuery query) {
        return QProfileEditUsersDao.mapper(dbSession).countByQuery(query);
    }

    public List<UserMembershipDto> selectByQuery(DbSession dbSession, SearchUsersQuery query, Pagination pagination) {
        return QProfileEditUsersDao.mapper(dbSession).selectByQuery(query, pagination);
    }

    public List<String> selectQProfileUuidsByOrganizationAndUser(DbSession dbSession, OrganizationDto organization, UserDto userDto) {
        return QProfileEditUsersDao.mapper(dbSession).selectQProfileUuidsByOrganizationAndUser(organization.getUuid(), userDto.getId());
    }

    public void insert(DbSession dbSession, QProfileEditUsersDto dto) {
        QProfileEditUsersDao.mapper(dbSession).insert(dto, this.system2.now());
    }

    public void deleteByQProfileAndUser(DbSession dbSession, QProfileDto profile, UserDto user) {
        QProfileEditUsersDao.mapper(dbSession).delete(profile.getKee(), user.getId());
    }

    public void deleteByQProfiles(DbSession dbSession, List<QProfileDto> qProfiles) {
        DatabaseUtils.executeLargeUpdates((Collection)((Collection)qProfiles.stream().map(QProfileDto::getKee).collect(MoreCollectors.toList())), p -> QProfileEditUsersDao.mapper(dbSession).deleteByQProfiles((Collection<String>)p));
    }

    public void deleteByUser(DbSession dbSession, UserDto user) {
        QProfileEditUsersDao.mapper(dbSession).deleteByUser(user.getId());
    }

    public void deleteByOrganizationAndUser(DbSession dbSession, OrganizationDto organization, UserDto user) {
        QProfileEditUsersDao.mapper(dbSession).deleteByOrganizationAndUser(organization.getUuid(), user.getId());
    }

    private static QProfileEditUsersMapper mapper(DbSession dbSession) {
        return (QProfileEditUsersMapper)dbSession.getMapper(QProfileEditUsersMapper.class);
    }
}

