/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;

public class SearchUsersQuery {
    public static final String ANY = "ANY";
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final Set<String> AVAILABLE_MEMBERSHIPS = ImmutableSet.of((Object)"ANY", (Object)"IN", (Object)"OUT");
    private final String organizationUuid;
    private final String qProfileUuid;
    private final String query;
    private final String membership;
    final String querySql;
    final String querySqlLowercase;

    private SearchUsersQuery(Builder builder) {
        this.organizationUuid = builder.organization.getUuid();
        this.qProfileUuid = builder.profile.getKee();
        this.query = builder.query;
        this.membership = builder.membership;
        this.querySql = this.query == null ? null : DaoUtils.buildLikeValue(this.query, WildcardPosition.BEFORE_AND_AFTER);
        this.querySqlLowercase = this.querySql == null ? null : this.querySql.toLowerCase(Locale.ENGLISH);
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public String getQProfileUuid() {
        return this.qProfileUuid;
    }

    public String getMembership() {
        return this.membership;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OrganizationDto organization;
        private QProfileDto profile;
        private String query;
        private String membership;

        private Builder() {
        }

        public Builder setOrganization(OrganizationDto organization) {
            this.organization = organization;
            return this;
        }

        public Builder setProfile(QProfileDto profile) {
            this.profile = profile;
            return this;
        }

        public Builder setMembership(@Nullable String membership) {
            this.membership = membership;
            return this;
        }

        public Builder setQuery(@Nullable String s) {
            this.query = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        private void initMembership() {
            this.membership = (String)MoreObjects.firstNonNull((Object)this.membership, (Object)SearchUsersQuery.ANY);
            Preconditions.checkArgument((boolean)AVAILABLE_MEMBERSHIPS.contains(this.membership), (Object)("Membership is not valid (got " + this.membership + "). Availables values are " + AVAILABLE_MEMBERSHIPS));
        }

        public SearchUsersQuery build() {
            Objects.requireNonNull(this.organization, "Organization cannot be null");
            Objects.requireNonNull(this.profile, "Quality profile cant be null.");
            this.initMembership();
            return new SearchUsersQuery(this);
        }
    }
}

