/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.user.GroupMembershipDto;
import org.sonar.db.user.GroupMembershipMapper;
import org.sonar.db.user.GroupMembershipQuery;
import org.sonar.db.user.GroupUserCount;
import org.sonar.db.user.LoginGroup;
import org.sonar.db.user.UserMembershipDto;
import org.sonar.db.user.UserMembershipQuery;

public class GroupMembershipDao
implements Dao {
    public List<GroupMembershipDto> selectGroups(DbSession session, GroupMembershipQuery query, Integer userId, int offset, int limit) {
        ImmutableMap params = ImmutableMap.of((Object)"query", (Object)query, (Object)"userId", (Object)userId, (Object)"organizationUuid", (Object)query.organizationUuid());
        return GroupMembershipDao.mapper(session).selectGroups((Map<String, Object>)params, new RowBounds(offset, limit));
    }

    public int countGroups(DbSession session, GroupMembershipQuery query, Integer userId) {
        ImmutableMap params = ImmutableMap.of((Object)"query", (Object)query, (Object)"userId", (Object)userId, (Object)"organizationUuid", (Object)query.organizationUuid());
        return GroupMembershipDao.mapper(session).countGroups((Map<String, Object>)params);
    }

    public List<UserMembershipDto> selectMembers(DbSession session, UserMembershipQuery query, int offset, int limit) {
        ImmutableMap params = ImmutableMap.of((Object)"query", (Object)query, (Object)"groupId", (Object)query.groupId(), (Object)"organizationUuid", (Object)query.organizationUuid());
        return GroupMembershipDao.mapper(session).selectMembers((Map<String, Object>)params, new RowBounds(offset, limit));
    }

    public int countMembers(DbSession session, UserMembershipQuery query) {
        ImmutableMap params = ImmutableMap.of((Object)"query", (Object)query, (Object)"groupId", (Object)query.groupId(), (Object)"organizationUuid", (Object)query.organizationUuid());
        return GroupMembershipDao.mapper(session).countMembers((Map<String, Object>)params);
    }

    public Map<String, Integer> countUsersByGroups(DbSession session, Collection<Integer> groupIds) {
        HashMap result = Maps.newHashMap();
        DatabaseUtils.executeLargeInputs(groupIds, input -> {
            List<GroupUserCount> userCounts = GroupMembershipDao.mapper(session).countUsersByGroup((List<Integer>)input);
            for (GroupUserCount count : userCounts) {
                result.put(count.groupName(), count.userCount());
            }
            return userCounts;
        });
        return result;
    }

    public List<Integer> selectGroupIdsByUserId(DbSession dbSession, int userId) {
        return GroupMembershipDao.mapper(dbSession).selectGroupIdsByUserId(userId);
    }

    public Multiset<String> countGroupByLoginsAndOrganization(DbSession dbSession, Collection<String> logins, String organizationUuid) {
        ArrayListMultimap result = ArrayListMultimap.create();
        DatabaseUtils.executeLargeInputs(logins, arg_0 -> GroupMembershipDao.lambda$countGroupByLoginsAndOrganization$1(dbSession, organizationUuid, (Multimap)result, arg_0));
        return result.keys();
    }

    public Multimap<String, String> selectGroupsByLogins(DbSession session, Collection<String> logins) {
        ArrayListMultimap result = ArrayListMultimap.create();
        DatabaseUtils.executeLargeInputs(logins, arg_0 -> GroupMembershipDao.lambda$selectGroupsByLogins$2(session, (Multimap)result, arg_0));
        return result;
    }

    private static GroupMembershipMapper mapper(DbSession session) {
        return (GroupMembershipMapper)session.getMapper(GroupMembershipMapper.class);
    }

    private static /* synthetic */ List lambda$selectGroupsByLogins$2(DbSession session, Multimap result, List input) {
        List<LoginGroup> groupMemberships = GroupMembershipDao.mapper(session).selectGroupsByLogins(input);
        for (LoginGroup membership : groupMemberships) {
            result.put((Object)membership.login(), (Object)membership.groupName());
        }
        return groupMemberships;
    }

    private static /* synthetic */ List lambda$countGroupByLoginsAndOrganization$1(DbSession dbSession, String organizationUuid, Multimap result, List input) {
        List<LoginGroup> groupMemberships = GroupMembershipDao.mapper(dbSession).selectGroupsByLoginsAndOrganization(input, organizationUuid);
        for (LoginGroup membership : groupMemberships) {
            result.put((Object)membership.login(), (Object)membership.groupName());
        }
        return groupMemberships;
    }
}

