/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;

public class UserMembershipQuery {
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final String ANY = "ANY";
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final Set<String> AVAILABLE_MEMBERSHIPS = ImmutableSet.of((Object)"ANY", (Object)"IN", (Object)"OUT");
    private final int groupId;
    private final String organizationUuid;
    private final String membership;
    private final String memberSearch;
    final String memberSearchSql;
    final String memberSearchSqlLowercase;
    private final int pageSize;
    private final int pageIndex;

    private UserMembershipQuery(Builder builder) {
        this.groupId = builder.groupId;
        this.organizationUuid = builder.organizationUuid;
        this.membership = builder.membership;
        this.memberSearch = builder.memberSearch;
        this.memberSearchSql = this.memberSearch == null ? null : DaoUtils.buildLikeValue(this.memberSearch, WildcardPosition.BEFORE_AND_AFTER);
        this.memberSearchSqlLowercase = this.memberSearchSql == null ? null : this.memberSearchSql.toLowerCase(Locale.ENGLISH);
        this.pageSize = builder.pageSize;
        this.pageIndex = builder.pageIndex;
    }

    public int groupId() {
        return this.groupId;
    }

    public String organizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String membership() {
        return this.membership;
    }

    @CheckForNull
    public String memberSearch() {
        return this.memberSearch;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer groupId;
        private String organizationUuid;
        private String membership;
        private String memberSearch;
        private Integer pageIndex = 1;
        private Integer pageSize = 100;

        private Builder() {
        }

        public Builder groupId(Integer groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder organizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder membership(@Nullable String membership) {
            this.membership = membership;
            return this;
        }

        public Builder memberSearch(@Nullable String s) {
            this.memberSearch = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        public Builder pageSize(@Nullable Integer i) {
            this.pageSize = i;
            return this;
        }

        public Builder pageIndex(@Nullable Integer i) {
            this.pageIndex = i;
            return this;
        }

        private void initMembership() {
            this.membership = (String)MoreObjects.firstNonNull((Object)this.membership, (Object)UserMembershipQuery.ANY);
            Preconditions.checkArgument((boolean)AVAILABLE_MEMBERSHIPS.contains(this.membership), (Object)("Membership is not valid (got " + this.membership + "). Availables values are " + AVAILABLE_MEMBERSHIPS));
        }

        private void initPageSize() {
            this.pageSize = (Integer)MoreObjects.firstNonNull((Object)this.pageSize, (Object)100);
        }

        private void initPageIndex() {
            this.pageIndex = (Integer)MoreObjects.firstNonNull((Object)this.pageIndex, (Object)1);
            Preconditions.checkArgument((this.pageIndex > 0 ? 1 : 0) != 0, (Object)("Page index must be greater than 0 (got " + this.pageIndex + ")"));
        }

        public UserMembershipQuery build() {
            Objects.requireNonNull(this.groupId, "Group ID cant be null.");
            Objects.requireNonNull(this.organizationUuid, "Organization UUID cannot be null");
            this.initMembership();
            this.initPageIndex();
            this.initPageSize();
            return new UserMembershipQuery(this);
        }
    }
}

