/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import org.sonar.db.Database;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.charset.CharsetHandler;
import org.sonar.server.platform.db.migration.charset.MssqlCharsetHandler;
import org.sonar.server.platform.db.migration.charset.MssqlMetadataReader;
import org.sonar.server.platform.db.migration.charset.MysqlCharsetHandler;
import org.sonar.server.platform.db.migration.charset.OracleCharsetHandler;
import org.sonar.server.platform.db.migration.charset.PostgresCharsetHandler;
import org.sonar.server.platform.db.migration.charset.PostgresMetadataReader;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

public class DatabaseCharsetChecker {
    private final Database db;
    private final SqlExecutor sqlExecutor;

    public DatabaseCharsetChecker(Database db) {
        this(db, new SqlExecutor());
    }

    @VisibleForTesting
    DatabaseCharsetChecker(Database db, SqlExecutor sqlExecutor) {
        this.db = db;
        this.sqlExecutor = sqlExecutor;
    }

    public void check(State state) {
        try (Connection connection = this.db.getDataSource().getConnection();){
            CharsetHandler handler = this.getHandler(this.db.getDialect());
            if (handler != null) {
                handler.handle(connection, state);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @CheckForNull
    @VisibleForTesting
    CharsetHandler getHandler(Dialect dialect) {
        switch (dialect.getId()) {
            case "h2": {
                return null;
            }
            case "oracle": {
                return new OracleCharsetHandler(this.sqlExecutor);
            }
            case "postgresql": {
                return new PostgresCharsetHandler(this.sqlExecutor, new PostgresMetadataReader(this.sqlExecutor));
            }
            case "mysql": {
                return new MysqlCharsetHandler(this.sqlExecutor);
            }
            case "mssql": {
                return new MssqlCharsetHandler(this.sqlExecutor, new MssqlMetadataReader(this.sqlExecutor));
            }
        }
        throw new IllegalArgumentException("Database not supported: " + dialect.getId());
    }

    public static enum State {
        FRESH_INSTALL,
        UPGRADE,
        STARTUP;

    }
}

