/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class VarcharColumnDef
extends AbstractColumnDef {
    public static final int MAX_SIZE = 4000;
    @Deprecated
    public static final int UUID_VARCHAR_SIZE = 50;
    public static final int UUID_SIZE = 40;
    private final int columnSize;
    private final boolean ignoreOracleUnit;

    private VarcharColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, builder.defaultValue);
        this.columnSize = builder.columnSize;
        this.ignoreOracleUnit = builder.ignoreOracleUnit;
    }

    public static Builder newVarcharColumnDefBuilder() {
        return new Builder();
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "mssql": {
                return String.format("NVARCHAR (%d)", this.columnSize);
            }
            case "oracle": {
                return String.format("VARCHAR2 (%d%s)", this.columnSize, this.ignoreOracleUnit ? "" : " CHAR");
            }
        }
        return String.format("VARCHAR (%d)", this.columnSize);
    }

    public static class Builder {
        @CheckForNull
        private Integer columnSize;
        @CheckForNull
        private String columnName;
        @CheckForNull
        private String defaultValue = null;
        private boolean isNullable = true;
        private boolean ignoreOracleUnit = false;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setLimit(int limit) {
            this.columnSize = limit;
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setDefaultValue(@Nullable String s) {
            this.defaultValue = s;
            return this;
        }

        public Builder setIgnoreOracleUnit(boolean b) {
            this.ignoreOracleUnit = b;
            return this;
        }

        public VarcharColumnDef build() {
            Validations.validateColumnName(this.columnName);
            Objects.requireNonNull(this.columnSize, "Limit cannot be null");
            return new VarcharColumnDef(this);
        }
    }
}

