/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.IntegerColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

public class CreateTableBuilder {
    private final Dialect dialect;
    private final String tableName;
    private final List<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
    private final List<ColumnDef> pkColumnDefs = new ArrayList<ColumnDef>(2);
    private final Multimap<ColumnDef, ColumnFlag> flagsByColumn = HashMultimap.create((int)1, (int)1);
    @CheckForNull
    private String pkConstraintName;

    public CreateTableBuilder(Dialect dialect, String tableName) {
        this.dialect = Objects.requireNonNull(dialect, "dialect can't be null");
        this.tableName = Validations.validateTableName(tableName);
    }

    public boolean tableExists(Database database) throws SQLException {
        try (Connection connection = database.getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)this.tableName, (Connection)connection);
            return bl;
        }
    }

    public List<String> build() {
        Preconditions.checkState((!this.columnDefs.isEmpty() || !this.pkColumnDefs.isEmpty() ? 1 : 0) != 0, (Object)"at least one column must be specified");
        return (List)Stream.concat(Stream.of(this.createTableStatement()), this.createOracleAutoIncrementStatements()).collect(MoreCollectors.toList());
    }

    public CreateTableBuilder addColumn(ColumnDef columnDef) {
        this.columnDefs.add(Objects.requireNonNull(columnDef, "column def can't be null"));
        return this;
    }

    public CreateTableBuilder addPkColumn(ColumnDef columnDef, ColumnFlag ... flags) {
        this.pkColumnDefs.add(Objects.requireNonNull(columnDef, "column def can't be null"));
        this.addFlags(columnDef, flags);
        return this;
    }

    private void addFlags(ColumnDef columnDef, ColumnFlag[] flags) {
        Arrays.stream(flags).forEach(flag -> {
            Objects.requireNonNull(flag, "flag can't be null");
            if (flag == ColumnFlag.AUTO_INCREMENT) {
                this.validateColumnDefForAutoIncrement(columnDef);
            }
            this.flagsByColumn.put((Object)columnDef, (Object)flag);
        });
    }

    private void validateColumnDefForAutoIncrement(ColumnDef columnDef) {
        Preconditions.checkArgument((boolean)"id".equals(columnDef.getName()), (Object)"Auto increment column name must be id");
        Preconditions.checkArgument((columnDef instanceof BigIntegerColumnDef || columnDef instanceof IntegerColumnDef ? 1 : 0) != 0, (Object)"Auto increment column must either be BigInteger or Integer");
        Preconditions.checkArgument((!columnDef.isNullable() ? 1 : 0) != 0, (Object)"Auto increment column can't be nullable");
        Preconditions.checkState((this.pkColumnDefs.stream().filter(this::isAutoIncrement).count() == 0L ? 1 : 0) != 0, (Object)"There can't be more than one auto increment column");
    }

    public CreateTableBuilder withPkConstraintName(String pkConstraintName) {
        this.pkConstraintName = Validations.validateConstraintName(pkConstraintName);
        return this;
    }

    private String createTableStatement() {
        StringBuilder res = new StringBuilder("CREATE TABLE ");
        res.append(this.tableName);
        res.append(" (");
        this.appendPkColumns(res);
        this.appendColumns(res, this.dialect, this.columnDefs);
        this.appendPkConstraint(res);
        res.append(')');
        CreateTableBuilder.appendCollationClause(res, this.dialect);
        return res.toString();
    }

    private void appendPkColumns(StringBuilder res) {
        this.appendColumns(res, this.dialect, this.pkColumnDefs);
        if (!this.pkColumnDefs.isEmpty() && !this.columnDefs.isEmpty()) {
            res.append(',');
        }
    }

    private void appendColumns(StringBuilder res, Dialect dialect, List<ColumnDef> columnDefs) {
        if (columnDefs.isEmpty()) {
            return;
        }
        Iterator<ColumnDef> columnDefIterator = columnDefs.iterator();
        while (columnDefIterator.hasNext()) {
            ColumnDef columnDef = columnDefIterator.next();
            res.append(columnDef.getName());
            res.append(' ');
            this.appendDataType(res, dialect, columnDef);
            this.appendDefaultValue(res, columnDef);
            CreateTableBuilder.appendNullConstraint(res, columnDef);
            this.appendColumnFlags(res, dialect, columnDef);
            if (!columnDefIterator.hasNext()) continue;
            res.append(',');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendDataType(StringBuilder res, Dialect dialect, ColumnDef columnDef) {
        if ("postgresql".equals(dialect.getId()) && this.isAutoIncrement(columnDef)) {
            if (columnDef instanceof BigIntegerColumnDef) {
                res.append("BIGSERIAL");
                return;
            } else {
                if (!(columnDef instanceof IntegerColumnDef)) throw new IllegalStateException("Column with autoincrement is neither BigInteger nor Integer");
                res.append("SERIAL");
            }
            return;
        } else {
            res.append(columnDef.generateSqlType(dialect));
        }
    }

    private boolean isAutoIncrement(ColumnDef columnDef) {
        Collection columnFlags = this.flagsByColumn.get((Object)columnDef);
        return columnFlags != null && columnFlags.contains((Object)ColumnFlag.AUTO_INCREMENT);
    }

    private static void appendNullConstraint(StringBuilder res, ColumnDef columnDef) {
        if (columnDef.isNullable()) {
            res.append(" NULL");
        } else {
            res.append(" NOT NULL");
        }
    }

    private void appendDefaultValue(StringBuilder sql, ColumnDef columnDef) {
        Object defaultValue = columnDef.getDefaultValue();
        if (defaultValue != null) {
            sql.append(" DEFAULT ");
            if (defaultValue instanceof String) {
                sql.append(String.format("'%s'", defaultValue));
            } else if (defaultValue instanceof Boolean) {
                sql.append((Boolean)defaultValue != false ? this.dialect.getTrueSqlValue() : this.dialect.getFalseSqlValue());
            } else {
                sql.append(defaultValue);
            }
        }
    }

    private void appendColumnFlags(StringBuilder res, Dialect dialect, ColumnDef columnDef) {
        Collection columnFlags = this.flagsByColumn.get((Object)columnDef);
        if (columnFlags != null && columnFlags.contains((Object)ColumnFlag.AUTO_INCREMENT)) {
            switch (dialect.getId()) {
                case "oracle": {
                    break;
                }
                case "postgresql": {
                    break;
                }
                case "mssql": {
                    res.append(" IDENTITY (1,1)");
                    break;
                }
                case "mysql": {
                    res.append(" AUTO_INCREMENT");
                    break;
                }
                case "h2": {
                    res.append(" AUTO_INCREMENT (1,1)");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported dialect id " + dialect.getId());
                }
            }
        }
    }

    private void appendPkConstraint(StringBuilder res) {
        if (this.pkColumnDefs.isEmpty()) {
            return;
        }
        res.append(", ");
        res.append("CONSTRAINT ");
        this.appendPkConstraintName(res);
        res.append(" PRIMARY KEY ");
        res.append('(');
        CreateTableBuilder.appendColumnNames(res, this.pkColumnDefs);
        res.append(')');
    }

    private void appendPkConstraintName(StringBuilder res) {
        if (this.pkConstraintName == null) {
            res.append("pk_").append(this.tableName);
        } else {
            res.append(this.pkConstraintName.toLowerCase(Locale.ENGLISH));
        }
    }

    private static void appendColumnNames(StringBuilder res, List<ColumnDef> columnDefs) {
        Iterator<ColumnDef> columnDefIterator = columnDefs.iterator();
        while (columnDefIterator.hasNext()) {
            res.append(columnDefIterator.next().getName());
            if (!columnDefIterator.hasNext()) continue;
            res.append(',');
        }
    }

    private static void appendCollationClause(StringBuilder res, Dialect dialect) {
        if ("mysql".equals(dialect.getId())) {
            res.append(" ENGINE=InnoDB CHARACTER SET utf8 COLLATE utf8_bin");
        }
    }

    private Stream<String> createOracleAutoIncrementStatements() {
        if (!"oracle".equals(this.dialect.getId())) {
            return Stream.empty();
        }
        return this.pkColumnDefs.stream().filter(this::isAutoIncrement).flatMap(columnDef -> Stream.of(CreateTableBuilder.createSequenceFor(this.tableName), CreateTableBuilder.createOracleTriggerForTable(this.tableName)));
    }

    private static String createSequenceFor(String tableName) {
        return "CREATE SEQUENCE " + tableName + "_seq START WITH 1 INCREMENT BY 1";
    }

    static String createOracleTriggerForTable(String tableName) {
        return "CREATE OR REPLACE TRIGGER " + tableName + "_idt BEFORE INSERT ON " + tableName + " FOR EACH ROW BEGIN IF :new.id IS null THEN SELECT " + tableName + "_seq.nextval INTO :new.id FROM dual; END IF; END;";
    }

    public static enum ColumnFlag {
        AUTO_INCREMENT;

    }
}

