/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.Validations;

public class DropTableBuilder {
    private final Dialect dialect;
    private final String tableName;

    public DropTableBuilder(Dialect dialect, String tableName) {
        this.dialect = Objects.requireNonNull(dialect, "dialect can't be null");
        this.tableName = Validations.validateTableName(tableName);
    }

    public List<String> build() {
        switch (this.dialect.getId()) {
            case "oracle": {
                return DropTableBuilder.forOracle(this.tableName);
            }
            case "h2": 
            case "mysql": 
            case "postgresql": {
                return Collections.singletonList("drop table if exists " + this.tableName);
            }
            case "mssql": {
                return Collections.singletonList("drop table " + this.tableName);
            }
        }
        throw new IllegalStateException("Unsupported DB: " + this.dialect.getId());
    }

    private static List<String> forOracle(String tableName) {
        return Arrays.asList(DropTableBuilder.dropIfExistsOnOracle("DROP SEQUENCE " + tableName + "_seq", -2289), DropTableBuilder.dropIfExistsOnOracle("DROP TRIGGER " + tableName + "_idt", -4080), DropTableBuilder.dropIfExistsOnOracle("DROP TABLE " + tableName, -942));
    }

    private static String dropIfExistsOnOracle(String command, int codeIfNotExists) {
        return "BEGIN\nEXECUTE IMMEDIATE '" + command + "';\nEXCEPTION\nWHEN OTHERS THEN\n  IF SQLCODE != " + codeIfNotExists + " THEN\n  RAISE;\n  END IF;\nEND;";
    }
}

