/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.api.config.Configuration;
import org.sonar.db.Database;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.MigrationStep;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SelectImpl;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.step.UpsertImpl;

public abstract class DataChange
implements MigrationStep {
    private final Database db;

    public DataChange(Database db) {
        this.db = db;
    }

    protected final Dialect getDialect() {
        return this.db.getDialect();
    }

    @Override
    public final void execute() throws SQLException {
        try (Connection readConnection = this.createReadUncommittedConnection();
             Connection writeConnection = this.createDdlConnection();){
            Context context = new Context(this.db, readConnection, writeConnection);
            this.execute(context);
        }
    }

    protected abstract void execute(Context var1) throws SQLException;

    private Connection createReadUncommittedConnection() throws SQLException {
        Connection connection = this.db.getDataSource().getConnection();
        connection.setAutoCommit(false);
        if (connection.getMetaData().supportsTransactionIsolationLevel(1)) {
            connection.setTransactionIsolation(1);
        }
        return connection;
    }

    private Connection createDdlConnection() throws SQLException {
        Connection res = this.db.getDataSource().getConnection();
        res.setAutoCommit(false);
        return res;
    }

    protected static boolean isSonarCloud(Configuration configuration) {
        return configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false);
    }

    public static class Context {
        private final Database db;
        private final Connection readConnection;
        private final Connection writeConnection;

        public Context(Database db, Connection readConnection, Connection writeConnection) {
            this.db = db;
            this.readConnection = readConnection;
            this.writeConnection = writeConnection;
        }

        public Select prepareSelect(String sql) throws SQLException {
            return SelectImpl.create(this.db, this.readConnection, sql);
        }

        public Upsert prepareUpsert(String sql) throws SQLException {
            return UpsertImpl.create(this.writeConnection, sql);
        }

        public MassUpdate prepareMassUpdate() {
            return new MassUpdate(this.db, this.readConnection, this.writeConnection);
        }
    }
}

