/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public interface Select
extends SqlStatement<Select> {
    public static final RowReader<Long> LONG_READER = new LongReader();

    public <T> List<T> list(RowReader<T> var1) throws SQLException;

    @CheckForNull
    public <T> T get(RowReader<T> var1) throws SQLException;

    public void scroll(RowHandler var1) throws SQLException;

    @FunctionalInterface
    public static interface RowHandler {
        public void handle(Row var1) throws SQLException;
    }

    public static class StringReader
    implements RowReader<String> {
        @Override
        public String read(Row row) throws SQLException {
            return row.getNullableString(1);
        }
    }

    public static class LongReader
    implements RowReader<Long> {
        private LongReader() {
        }

        @Override
        public Long read(Row row) throws SQLException {
            return row.getNullableLong(1);
        }
    }

    @FunctionalInterface
    public static interface RowReader<T> {
        public T read(Row var1) throws SQLException;
    }

    public static class Row {
        private final ResultSet rs;

        Row(ResultSet rs) {
            this.rs = rs;
        }

        @CheckForNull
        public Long getNullableLong(int columnIndex) throws SQLException {
            long l = this.rs.getLong(columnIndex);
            return this.rs.wasNull() ? null : Long.valueOf(l);
        }

        public long getLong(int columnIndex) throws SQLException {
            return this.rs.getLong(columnIndex);
        }

        @CheckForNull
        public Double getNullableDouble(int columnIndex) throws SQLException {
            double d = this.rs.getDouble(columnIndex);
            return this.rs.wasNull() ? null : Double.valueOf(d);
        }

        public double getDouble(int columnIndex) throws SQLException {
            return this.rs.getDouble(columnIndex);
        }

        @CheckForNull
        public Integer getNullableInt(int columnIndex) throws SQLException {
            int i = this.rs.getInt(columnIndex);
            return this.rs.wasNull() ? null : Integer.valueOf(i);
        }

        public int getInt(int columnIndex) throws SQLException {
            return this.rs.getInt(columnIndex);
        }

        @CheckForNull
        public Boolean getNullableBoolean(int columnIndex) throws SQLException {
            boolean b = this.rs.getBoolean(columnIndex);
            return this.rs.wasNull() ? null : Boolean.valueOf(b);
        }

        public boolean getBoolean(int columnIndex) throws SQLException {
            return this.rs.getBoolean(columnIndex);
        }

        @CheckForNull
        public String getNullableString(int columnIndex) throws SQLException {
            String s = this.rs.getString(columnIndex);
            return this.rs.wasNull() ? null : s;
        }

        public String getString(int columnIndex) throws SQLException {
            return this.rs.getString(columnIndex);
        }

        @CheckForNull
        public Date getNullableDate(int columnIndex) throws SQLException {
            Timestamp t = this.rs.getTimestamp(columnIndex);
            return this.rs.wasNull() ? null : t;
        }

        public Date getDate(int columnIndex) throws SQLException {
            return this.rs.getTimestamp(columnIndex);
        }

        @CheckForNull
        public byte[] getNullableBytes(int columnIndex) throws SQLException {
            byte[] b = this.rs.getBytes(columnIndex);
            return this.rs.wasNull() ? null : b;
        }

        public byte[] getBytes(int columnIndex) throws SQLException {
            return this.rs.getBytes(columnIndex);
        }

        public String toString() {
            try {
                ResultSetMetaData rsMetaData = this.rs.getMetaData();
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                    if (i > 1) {
                        sb.append(",");
                    }
                    sb.append(rsMetaData.getColumnLabel(i).toLowerCase());
                    sb.append("=");
                    sb.append(this.rs.getObject(i));
                }
                return sb.toString();
            }
            catch (Exception e) {
                return "Unavailable: " + e.getMessage();
            }
        }
    }
}

