/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.BaseSqlStatement;
import org.sonar.server.platform.db.migration.step.Select;

public class SelectImpl
extends BaseSqlStatement<Select>
implements Select {
    private SelectImpl(PreparedStatement pstmt) {
        super(pstmt);
    }

    @Override
    public <T> List<T> list(Select.RowReader<T> reader) throws SQLException {
        ResultSet rs = this.pstmt.executeQuery();
        Select.Row row = new Select.Row(rs);
        try {
            ArrayList<T> rows = new ArrayList<T>();
            while (rs.next()) {
                rows.add(reader.read(row));
            }
            ArrayList<T> arrayList = rows;
            return arrayList;
        }
        catch (Exception e) {
            throw SelectImpl.newExceptionWithRowDetails(row, e);
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rs);
            this.close();
        }
    }

    @Override
    public <T> T get(Select.RowReader<T> reader) throws SQLException {
        ResultSet rs = this.pstmt.executeQuery();
        Select.Row row = new Select.Row(rs);
        try {
            if (rs.next()) {
                T t = reader.read(row);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            throw SelectImpl.newExceptionWithRowDetails(row, e);
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rs);
            this.close();
        }
    }

    @Override
    public void scroll(Select.RowHandler handler) throws SQLException {
        ResultSet rs = this.pstmt.executeQuery();
        Select.Row row = new Select.Row(rs);
        try {
            while (rs.next()) {
                handler.handle(row);
            }
        }
        catch (Exception e) {
            throw SelectImpl.newExceptionWithRowDetails(row, e);
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rs);
            this.close();
        }
    }

    private static IllegalStateException newExceptionWithRowDetails(Select.Row row, Exception e) {
        return new IllegalStateException("Error during processing of row: [" + row + "]", e);
    }

    public static SelectImpl create(Database db, Connection connection, String sql) throws SQLException {
        PreparedStatement pstmt = connection.prepareStatement(sql, 1003, 1007);
        pstmt.setFetchSize(db.getDialect().getScrollDefaultFetchSize());
        return new SelectImpl(pstmt);
    }
}

