/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class DeleteOrphanDuplicationsIndexRowsWithoutComponentOrAnalysis
extends DataChange {
    public DeleteOrphanDuplicationsIndexRowsWithoutComponentOrAnalysis(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        DeleteOrphanDuplicationsIndexRowsWithoutComponentOrAnalysis.deleteRowsWithoutComponentUuid(context);
        DeleteOrphanDuplicationsIndexRowsWithoutComponentOrAnalysis.deleteRowsWithoutAnalysisUuid(context);
    }

    private static void deleteRowsWithoutComponentUuid(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT id from duplications_index where component_uuid is null");
        massUpdate.update("DELETE from duplications_index WHERE id=?");
        massUpdate.rowPluralName("duplications index rows without component");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, row.getLong(1));
            return true;
        });
    }

    private static void deleteRowsWithoutAnalysisUuid(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT distinct project_snapshot_id from duplications_index where analysis_uuid is null");
        massUpdate.update("DELETE from duplications_index WHERE project_snapshot_id=?");
        massUpdate.rowPluralName("duplications index rows without analysis");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, row.getLong(1));
            return true;
        });
    }
}

