/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateAnalysisUuidOnMeasures
extends DataChange {
    public PopulateAnalysisUuidOnMeasures(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Map<Long, String> rootSnapshotUuids = PopulateAnalysisUuidOnMeasures.loadRootSnapshotUuids(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct m.snapshot_id as sId, s.root_snapshot_id as rootSid from project_measures m inner join snapshots s on m.snapshot_id = s.id where m.analysis_uuid is null");
        massUpdate.update("update project_measures set analysis_uuid=? where snapshot_id = ? and analysis_uuid is null");
        massUpdate.rowPluralName("measures");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateAnalysisUuidOnMeasures.handleRow(row, update, rootSnapshotUuids));
    }

    private static Map<Long, String> loadRootSnapshotUuids(DataChange.Context context) throws SQLException {
        HashMap<Long, String> snapshotUuidsByIds = new HashMap<Long, String>();
        context.prepareSelect("select distinct id, uuid from snapshots where depth=0").scroll(row -> snapshotUuidsByIds.put(row.getLong(1), row.getString(2)));
        return snapshotUuidsByIds;
    }

    private static boolean handleRow(Select.Row row, SqlStatement update, Map<Long, String> rootSnapshotUuids) throws SQLException {
        long snapshotId = row.getLong(1);
        Long rootSnapshotId = row.getNullableLong(2);
        String analysisUuid = rootSnapshotUuids.get(rootSnapshotId == null ? snapshotId : rootSnapshotId);
        if (analysisUuid == null) {
            return false;
        }
        update.setString(1, analysisUuid);
        update.setLong(2, snapshotId);
        return true;
    }
}

