/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUuidColumnOnSnapshots
extends DataChange {
    private final UuidFactory uuidFactory;

    public PopulateUuidColumnOnSnapshots(Database db, UuidFactory uuidFactory) {
        super(db);
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT s.id from snapshots s where s.uuid is null");
        massUpdate.update("UPDATE snapshots SET uuid=? WHERE id=?");
        massUpdate.rowPluralName("snapshots");
        massUpdate.execute(this::handle);
    }

    private boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long id = row.getLong(1);
        update.setString(1, this.uuidFactory.create());
        update.setLong(2, id);
        return true;
    }
}

