/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class RemoveUsersPasswordWhenNotLocal
extends DataChange {
    private final System2 system2;

    public RemoveUsersPasswordWhenNotLocal(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT u.id FROM users u WHERE (u.crypted_password IS NOT NULL OR u.salt IS NOT NULL) AND u.user_local=?").setBoolean(1, false);
        massUpdate.update("UPDATE users SET crypted_password=null, salt=null, updated_at=? WHERE id=?");
        massUpdate.rowPluralName("none local users with password");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, now);
            update.setLong(2, row.getLong(1));
            return true;
        });
    }
}

