/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanOrphanRowsInGroupRoles
extends DataChange {
    public CleanOrphanRowsInGroupRoles(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        CleanOrphanRowsInGroupRoles.deleteRowsWithoutComponent(context);
        CleanOrphanRowsInGroupRoles.deleteRowsForNonRootComponent(context);
    }

    private static void deleteRowsWithoutComponent(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct gr.resource_id from group_roles gr where gr.resource_id is not null and not exists (select id from projects p where p.id = gr.resource_id)");
        massUpdate.rowPluralName("rows without component");
        massUpdate.update("delete from group_roles where resource_id = ?");
        massUpdate.execute(CleanOrphanRowsInGroupRoles::handle);
    }

    private static void deleteRowsForNonRootComponent(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct gr.resource_id from group_roles gr inner join projects p on p.id = gr.resource_id where p.scope <> ? or (p.qualifier <> ? and p.qualifier <> ?)").setString(1, "PRJ").setString(2, "TRK").setString(3, "VW");
        massUpdate.rowPluralName("rows for non-root component");
        massUpdate.update("delete from group_roles where resource_id = ?");
        massUpdate.execute(CleanOrphanRowsInGroupRoles::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long resourceId = row.getLong(1);
        update.setLong(1, resourceId);
        return true;
    }
}

