/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanOrphanRowsInUserRoles
extends DataChange {
    public CleanOrphanRowsInUserRoles(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        CleanOrphanRowsInUserRoles.deleteRowsWithoutComponent(context);
        CleanOrphanRowsInUserRoles.deleteRowsForNonRootComponent(context);
    }

    private static void deleteRowsWithoutComponent(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct ur.resource_id from user_roles ur where ur.resource_id is not null and not exists (select id from projects p where p.id = ur.resource_id)");
        massUpdate.rowPluralName("rows without component");
        massUpdate.update("delete from user_roles where resource_id = ?");
        massUpdate.execute(CleanOrphanRowsInUserRoles::handle);
    }

    private static void deleteRowsForNonRootComponent(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct ur.resource_id from user_roles ur inner join projects p on p.id = ur.resource_id where p.scope <> ? or (p.qualifier <> ? and p.qualifier <> ?)").setString(1, "PRJ").setString(2, "TRK").setString(3, "VW");
        massUpdate.rowPluralName("rows for non-root component");
        massUpdate.update("delete from user_roles where resource_id = ?");
        massUpdate.execute(CleanOrphanRowsInUserRoles::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        long resourceId = row.getLong(1);
        update.setLong(1, resourceId);
        return true;
    }
}

