/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.sql.DropColumnsBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class DropIsDefaultColumnFromRulesProfiles
extends DdlChange {
    private static final String TABLE_NAME = "rules_profiles";
    private static final String COLUMN_NAME = "is_default";

    public DropIsDefaultColumnFromRulesProfiles(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (this.getDialect().getId().equals("mssql")) {
            this.dropMssqlConstraints();
        }
        context.execute(new DropColumnsBuilder(this.getDialect(), TABLE_NAME, COLUMN_NAME).build());
    }

    private void dropMssqlConstraints() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();
             PreparedStatement pstmt = connection.prepareStatement(String.format("SELECT d.name FROM sys.default_constraints d INNER JOIN sys.columns AS c ON d.parent_column_id = c.column_id WHERE OBJECT_NAME(d.parent_object_id)='%s' AND c.name='%s'", TABLE_NAME, COLUMN_NAME));
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                String constraintName = rs.getString(1);
                DropIsDefaultColumnFromRulesProfiles.dropMssqlConstraint(connection, constraintName);
            }
        }
    }

    private static void dropMssqlConstraint(Connection connection, String constraintName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(String.format("ALTER TABLE %s DROP CONSTRAINT %s", TABLE_NAME, constraintName));
        }
    }
}

